#use "exemples/OCaml/Rubik/cube4x4/divers/mouvements.ml";;

let est_coin x = (x /|/ x) = 27;;
let est_angle x = (x /|/ x) = 19;;
let est_centre x = (x /|/ x) = 11;;


(* morphisme 's: M -> S' et section 'l: S -> M' *)
(* construction d'une section 'l' de la suite exacte '0 -> K -> M -> S -> 0' *)
(* En Caml on reprsente la sujection 's' par 'sur', la section 'l' par 'sec' et 'gij' par 'gg i j' *)

(* lments g_{ij} alias gg i j de G servant  construire cette section *)
let gk i =
	let gka j = match vect j with
			| (- 1, 3, 3) -> id
			| (- 1, 3, - 3) -> [|[|1; 0; 0|]; [|0; 0; - 1|]; [|0; 1; 0|]|]
			| (- 3, 3, - 1) -> [|[|0; 0; 1|]; [|0; 1; 0|]; [|- 1; 0; 0|]|]
			| (3, 1, 3) -> [|[|0; - 1; 0|]; [|1; 0; 0|]; [|0; 0; 1|]|]
			| (- 1, - 3, 3) -> [|[|1; 0; 0|]; [|0; 0; 1|]; [|0; - 1; 0|]|]
			| (3, 3, 1) -> [|[|0; 0; - 1|]; [|0; 1; 0|]; [|1; 0; 0|]|]
			| (- 3, - 1, 3) -> [|[|0; 1; 0|]; [|- 1; 0; 0|]; [|0; 0; 1|]|]
			| (- 1, - 3, - 3) -> [|[|1; 0; 0|]; [|0; - 1; 0|]; [|0; 0; - 1|]|]
			| (1, 3, - 3) -> [|[|- 1; 0; 0|]; [|0; 1; 0|]; [|0; 0; - 1|]|]
			| (1, - 3, 3) -> [|[|- 1; 0; 0|]; [|0; - 1; 0|]; [|0; 0; 1|]|]
			
			| (1, 3, 3) -> [|[|- 1; 0; 0|]; [|0; 0; 1|]; [|0; 1; 0|]|]
			| (1, - 3, - 3) -> [|[|- 1; 0; 0|]; [|0; 0; - 1|]; [|0; - 1; 0|]|]
			| (3, - 3, - 1) -> [|[|0; 0; 1|]; [|0; - 1; 0|]; [|1; 0; 0|]|]
			| (- 3, - 3, 1) -> [|[|0; 0; - 1|]; [|0; - 1; 0|]; [|- 1; 0; 0|]|]
			| (3, - 1, - 3) -> [|[|0; 1; 0|]; [|1; 0; 0|]; [|0; 0; - 1|]|]
			| (- 3, 1, - 3) -> [|[|0; - 1; 0|]; [|- 1; 0; 0|]; [|0; 0; - 1|]|]
			| (- 3, - 1, - 3) -> [|[|0; 1; 0|]; [|0; 0; - 1|]; [|- 1; 0; 0|]|]
			| (- 3, - 3, - 1) -> [|[|0; 0; 1|]; [|- 1; 0; 0|]; [|0; - 1; 0|]|]
			| (- 3, 3, 1) -> [|[|0; 0; - 1|]; [|- 1; 0; 0|]; [|0; 1; 0|]|]
			| (3, - 1, 3) -> [|[|0; 1; 0|]; [|0; 0; 1|]; [|1; 0; 0|]|]
			| (3, - 3, 1) -> [|[|0; 0; - 1|]; [|1; 0; 0|]; [|0; - 1; 0|]|]
			| (3, 1, - 3) -> [|[|0; - 1; 0|]; [|0; 0; - 1|]; [|1; 0; 0|]|]
			| (- 3, 1, 3) -> [|[|0; - 1; 0|]; [|0; 0; 1|]; [|- 1; 0; 0|]|]
			| (3, 3, - 1) -> [|[|0; 0; 1|]; [|1; 0; 0|]; [|0; 1; 0|]|]
			| _ -> failwith "gka"
	
	and gkc j = match vect j with
			| (3, 3, 3) (* kappa *) -> id
			| (3, - 3, 3) -> rot [|0; 0; 1|] (* gamma *)
			| (- 3, - 3, 3) -> [|[|- 1; 0; 0|]; [|0; - 1; 0|]; [|0; 0; 1|]|] (* gamma^2 *)
			| (- 3, 3, 3) -> rot' [|0; 0; 1|] (* gamma^3 *)
			
			| (- 3, - 3, - 3) -> [|[|0; 0; - 1|]; [|0; - 1; 0|]; [|- 1; 0; 0|]|] (* demi-tour / (1,0,-1) *)
			| (3, 3, - 3) -> rot [|1; 0; 0|]
			| (3, - 3, - 3) -> [|[|1; 0; 0|]; [|0; - 1; 0|]; [|0; 0; - 1|]|]
			| (- 3, 3, - 3) -> [|[|- 1; 0; 0|]; [|0; 1; 0|]; [|0; 0; - 1|]|]
			| _ -> failwith "gkc"
	
	and gkm j = match vect j with
			| (1, 1, 3) -> id
			| (- 3, 1, - 1) -> [|[|0; 1; 0|]; [|0; 0; - 1|]; [|- 1; 0; 0|]|];
			| (- 1, - 3, 1) -> [|[|0; 0; 1|]; [|- 1; 0; 0|]; [|0; - 1; 0|]|];
			| (- 1, 3, - 1) -> [|[|0; 0; - 1|]; [|- 1; 0; 0|]; [|0; 1; 0|]|];
			| (3, 1, 1) -> [|[|0; 1; 0|]; [|0; 0; 1|]; [|1; 0; 0|]|];
			| (1, - 3, - 1) -> [|[|0; 0; - 1|]; [|1; 0; 0|]; [|0; - 1; 0|]|];
			| (3, - 1, - 1) -> [|[|0; - 1; 0|]; [|0; 0; - 1|]; [|1; 0; 0|]|];
			| (- 3, - 1, 1) -> [|[|0; - 1; 0|]; [|0; 0; 1|]; [|- 1; 0; 0|]|];
			| (1, 3, 1) -> [|[|0; 0; 1|]; [|1; 0; 0|]; [|0; 1; 0|]|];
			
			| (1, 3, - 1) -> [|[|1; 0; 0|]; [|0; 0; - 1|]; [|0; 1; 0|]|];
			| (- 3, 1, 1) -> [|[|0; 0; 1|]; [|0; 1; 0|]; [|- 1; 0; 0|]|];
			| (1, - 1, 3) -> [|[|0; - 1; 0|]; [|1; 0; 0|]; [|0; 0; 1|]|];
			| (1, - 3, 1) -> [|[|1; 0; 0|]; [|0; 0; 1|]; [|0; - 1; 0|]|];
			| (3, 1, - 1) -> [|[|0; 0; - 1|]; [|0; 1; 0|]; [|1; 0; 0|]|];
			| (- 1, 1, 3) -> [|[|0; 1; 0|]; [|- 1; 0; 0|]; [|0; 0; 1|]|];
			| (1, - 1, - 3) -> [|[|1; 0; 0|]; [|0; - 1; 0|]; [|0; 0; - 1|]|];
			| (- 1, 1, - 3) -> [|[|- 1; 0; 0|]; [|0; 1; 0|]; [|0; 0; - 1|]|];
			| (- 1, - 1, 3) -> [|[|- 1; 0; 0|]; [|0; - 1; 0|]; [|0; 0; 1|]|];
			
			| (- 1, 3, 1) -> [|[|- 1; 0; 0|]; [|0; 0; 1|]; [|0; 1; 0|]|];
			| (- 1, - 3, - 1) -> [|[|- 1; 0; 0|]; [|0; 0; - 1|]; [|0; - 1; 0|]|];
			| (3, - 1, 1) -> [|[|0; 0; 1|]; [|0; - 1; 0|]; [|1; 0; 0|]|];
			| (- 3, - 1, - 1) -> [|[|0; 0; - 1|]; [|0; - 1; 0|]; [|- 1; 0; 0|]|];
			| (1, 1, - 3) -> [|[|0; 1; 0|]; [|1; 0; 0|]; [|0; 0; - 1|]|];
			| (- 1, - 1, - 3) -> [|[|0; - 1; 0|]; [|- 1; 0; 0|]; [|0; 0; - 1|]|]
			
			| _ -> failwith "gkm"
	
	in
		if est_angle i then gka i else if est_coin i then gkc i else if est_centre i then gkm i else id
;;

let gg i j = transpose (gk i) /./ gk j;;

(* dcomposition 'm = ker m /*/ sec (sur m)' d'un mouvement 'm' *)
(* avec 'ker m' lment du noyau de 'sur' *)
(* 'p' pour 'permutation': 'p = sur m' est la permutation 'p' des indices associe au mouvement 'm' *)
let sec p = mv1_of_fun (fun i -> gg i (p i));;
let sur m = fun i -> i /:/ fun_of_mv1 m i;;
let ker m = m /*/ inverse (sec (sur m));;


(* stabilisateur du coin i *)
(* les stabilisateurs des angles et des centres sont triviaux *)
let st i =
	let m = [|[|0; 0; 1|]; [|1; 0; 0|]; [|0; 1; 0|]|]
	in
		if est_coin i then
			transpose (gk i) /./ m /./ gk i
		else failwith "st"
;;
