(* projection du cube sur l'cran *)
(* dans 'xx v' et 'yy v', 'v' sert  dcaler les projections des faces caches *)
(* 'x,y,z' sont les coordonnes ADH *)

let ux = 20;;
let uy = 20;;
let ox = 333;;
let oy = 400;;

let proj x y z =
	let c = sqrt 6. /. 2. in
		(c *. (y -. x) /. sqrt 2., c *. (-. (x +. y) +. 2. *. z) /. sqrt 6.)
;;

let xx v pt3 =
	let (x, y, z) = vect (map_vect float_of_int pt3) in
		let (x1, y1, z1) =
			if v /|/ [|1; 1; 1|] = 1 then (x, y, z)
			else match vect v with
					| (_, 0, 0) -> (x -. 8., y, z)
					| (0, _, 0) -> (x, y -. 8., z)
					| _ -> (x, y, z -. 8.)
		in
			int_of_float (float_of_int ox +. fst (proj x1 y1 z1) *. float_of_int ux)
;;

let yy v pt3 =
	let (x, y, z) = vect (map_vect float_of_int pt3) in
		let (x1, y1, z1) =
			if v /|/ [|1; 1; 1|] = 1 then (x, y, z)
			else match vect v with
					| (_, 0, 0) -> (x -. 8., y, z)
					| (0, _, 0) -> (x, y -. 8., z)
					| _ -> (x, y, z -. 8.)
		in
			int_of_float (float_of_int oy +. snd (proj x1 y1 z1) *. float_of_int uy)
;;

(* numrotation des centres *)
let numero c = let est_centre i = (i /|/ i) = 11
	in
		if est_centre c then string_of_int (assoc c
				[
					[|- 1; - 1; 3|], 1; [|- 1; 1; 3|], 2; [|1; 1; 3|], 3; [|1; - 1; 3|], 0;
					[|- 1; - 1; - 3|], 0; [|- 1; 1; - 3|], 3; [|1; 1; - 3|], 2; [|1; - 1; - 3|], 1;
					
					[|3; - 1; - 1|], 0; [|3; - 1; 1|], 1; [|3; 1; 1|], 2; [|3; 1; - 1|], 3;
					[|- 1; - 3; - 1|], 0; [|- 1; - 3; 1|], 1; [|1; - 3; 1|], 2; [|1; - 3; - 1|], 3;
					[|- 3; - 1; - 1|], 1; [|- 3; - 1; 1|], 0; [|- 3; 1; 1|], 3; [|- 3; 1; - 1|], 2;
					[|- 1; 3; - 1|], 3; [|- 1; 3; 1|], 2; [|1; 3; 1|], 1; [|1; 3; - 1|], 0
				])
		else ""
;;

(* Simulation graphique du Rubik's cube *)

(* la fonction 'drawPoly' est utilise pour tracer le pourtour des projections *)
(* des faces des minicubes *)
let drawPoly poly =
	let (x, y) = poly.(0) in Graphics.moveto x y;
		for i = 1 to vect_length poly - 1 do
			let (x, y) = poly.(i) in Graphics.lineto x y
		done;
		let (x, y) = poly.(0) in Graphics.lineto x y;
;;

(* la fonction 'draw' est utilise pour dessiner la projection 'x' d'une face *)
(* de minicube en superposant le trac du pourtour  la couleur de remplissage *)
(* 'draw' avec inscription des numros des centres dans leur position actuelle *)
let draw x =
	let a, b, c = x in
		Graphics.set_color b;
		Graphics.fill_poly a;
		Graphics.set_color Graphics.black;
		drawPoly a;
		let
		((a1, b1), (a2, b2), (a3, b3), (a4, b4)) = (a.(0), a.(1), a.(2), a.(3))
		in
			let (c1, c2) = ((a1 + a3) / 2, (b1 + b3) / 2)
			in
				Graphics.moveto c1 c2;
				Graphics.draw_string c

;;

(* draw1 pour inscrire les numros des emplacements usine des centres *)
let draw1 x =
	let a, b, c = x and abs x = if x > 0 then x else - x in
		Graphics.set_color (Graphics.rgb 100 100 100);
		let
		((a1, b1), (a2, b2), (a3, b3), (a4, b4)) = (a.(0), a.(1), a.(2), a.(3))
		in
			let (c1, c2) = ((a1 + a3 - abs (a2 - a3) + 4) / 2, (b1 + b3 - abs (b2 - b3) + 4) / 2)
			in
				Graphics.moveto c1 c2;
				Graphics.draw_string c

;;

(* la fonction 'draw_face' est utilise pour dessiner la projection d'une face du *)
(* rubik's cube en appliquant 'draw' aux projections des faces des minicubes *)
(* qu'elle contient. Elle prend en paramtre le rsultat de 'proj_face' ci-dessous *)

let rec draw_face l = match l with
		| t :: r -> draw t; draw_face r
		| [] -> ()
;;

let rec draw_face1 l = match l with
		| t :: r -> draw1 t; draw_face1 r
		| [] -> ()
;;

(* les trois fonctions suivantes utilisent le repre du cube *)

(* 'face v c' renvoie, si le minicube  l'emplacement d'indice 'c' a une face F *)
(* dans la face du Rubik's cube normale au vecteur sortant 'v', sous forme de vecteur *)
(* une liste circulaire des 4 sommets de F *)
let face v c =
	(*if c /|/ c <> 1 then*)
	let e = v /|/ [|1; 1; 1|] in let w = [|e; e; e|] in
			let w1 = w /:/ rot v in
				let w2 = w1 /:/ rot v in
					let w3 = w2 /:/ rot v in
						let l = [w; w1; w2; w3] in
							let add m = for i = 0 to 2 do m.(i) <- m.(i) + c.(i) done
							in
								do_list add l; vect_of_list l
;;

(* pour la face F du rubick's cube repre par le vecteur normal sortant 'v', *)
(* 'face_color' associe  chaque minicube appartenant  cette face F et *)
(* repr par son indice la couleur qu'il prsente sur F *)
(* ainsi que son numro de 0  3 dans sa couleur si c'est un centre *)
(* et renvoie la liste d'associations *)
let face_colors v minicubes =
	let f x = (fst x) /:/ (snd x) in
		map (fun x -> (f x, (couleur_de_face (v /:/ transpose (snd x))), numero (fst x)))
		(select (fun x -> f x /|/ v = 3 && fst x /|/ fst x <> 9) minicubes)
;;

(* 'face_prepare' fournit, pour la face du rubik's cube normale au vecteur *)
(* sortant 'v', une liste de triplets: les triplets correspondent aux minicubes *)
(* dont une face F est incluse dans celle du Rubik's cube; la premire *)
(* composante est sous forme de vecteur une liste circulaire des 4 sommets *)
(* de F, la seconde composante est la couleur de F et la troisime dans le cas *)
(* d'un centre identifie par son numro ce dernier dans sa couleur *)
let face_prepare v minicubes =
	let l = face_colors v minicubes in
		map (fun (x, y, z) -> (face v x, y, z)) l
;;

(* on introduit dans les deux fonctions suivantes la matrice de passage 'p' *)
(* du repre ADH au repre OVB :(x=x'p) o 'x' est la ligne des coordonnes *)
(* d'espace et x' la ligne des coordonnes par rapport au cube *)

(* 'proj_face' renvoie, comme 'face_prepare', une liste de triplets *)
(* 'contour * couleur * numro' correspondant cette fois aux PROJECTIONS *)
(* des faces de minicubes contenues dans la face du Rubik's cube *)
(* orthogonale au vecteur sortant 'v' *)
let proj_face p mv1 v =
	let f = face_prepare v mv1 and
	proj_vect l =
		map_vect (fun x -> xx (v /:/ p) (x /:/ p), yy (v /:/ p) (x /:/ p)) l
	in
		map (fun (x, y, z) -> proj_vect x, y, z) f
;;

(* 'dessine_cube context mv1' dessine le cube dans l'tat 'mv1' *)
let dessine_cube context mv1 =
	let p = context.matrice and m = mv1 in
	(*faces opposes*)
		do_vect (fun x -> draw_face (proj_face p m x)) idm;
		(*faces frontales*)
		do_vect (fun x -> draw_face (proj_face p m x)) id;
		
		(* pour les numros des emplacements par dfaut des centres *)
		let e = map (fun x -> x, id) indices in
		(*faces opposes *)
			do_vect (fun x -> draw_face1 (proj_face p e x)) idm;
			(*faces frontales*)
			do_vect (fun x -> draw_face1 (proj_face p e x)) id;

;;
