/*
 Program WinCaml: Graphical User Interface
 for interactive use of Caml-Light and Ocaml.
 Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
 email: jean.mouric@orange.fr
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File lex.zz.cpp

#include <string>
extern size_t currentPos;
extern size_t token_length;

#define YY_NO_UNISTD_H
#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer zz_create_buffer
#define yy_delete_buffer zz_delete_buffer
#define yy_flex_debug zz_flex_debug
#define yy_init_buffer zz_init_buffer
#define yy_flush_buffer zz_flush_buffer
#define yy_load_buffer_state zz_load_buffer_state
#define yy_switch_to_buffer zz_switch_to_buffer
#define yyin zzin
#define yyleng zzleng
#define yylex zzlex
#define yylineno zzlineno
#define yyout zzout
#define yyrestart zzrestart
#define yytext zztext
#define yywrap zzwrap
#define yyalloc zzalloc
#define yyrealloc zzrealloc
#define yyfree zzfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE zzrestart(zzin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t zzleng;

extern FILE *zzin, *zzout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up zztext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up zztext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via zzrestart()), so that the user can continue scanning by
	 * just pointing zzin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when zztext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t zzleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow zzwrap()'s to do buffer switches
 * instead of setting up a fresh zzin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void zzrestart (FILE *input_file  );
void zz_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE zz_create_buffer (FILE *file,int size  );
void zz_delete_buffer (YY_BUFFER_STATE b  );
void zz_flush_buffer (YY_BUFFER_STATE b  );
void zzpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void zzpop_buffer_state (void );

static void zzensure_buffer_stack (void );
static void zz_load_buffer_state (void );
static void zz_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER zz_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE zz_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE zz_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE zz_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *zzalloc (yy_size_t  );
void *zzrealloc (void *,yy_size_t  );
void zzfree (void *  );

#define yy_new_buffer zz_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        zzensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            zz_create_buffer(zzin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        zzensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            zz_create_buffer(zzin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define zzwrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *zzin = (FILE *) 0, *zzout = (FILE *) 0;

typedef int yy_state_type;

extern int zzlineno;

int zzlineno = 1;

extern char *zztext;
#define yytext_ptr zztext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up zztext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	zzleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 116
#define YY_END_OF_BUFFER 117
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[240] =
    {   0,
        0,    0,    0,    0,    0,    0,  117,  115,   16,   12,
       12,   52,    8,  106,  113,   67,  111,   17,   18,   57,
       59,   53,   61,  107,   63,   13,   13,  108,   50,   70,
       20,   78,  105,  114,   98,  115,   99,   94,  109,  115,
      114,  114,  114,  114,  114,  114,  114,  114,  114,  114,
      114,  114,  114,  114,  114,   96,   21,   97,  112,    5,
        4,    5,    5,   11,  116,   10,   11,   16,   12,   12,
       12,  113,   56,   68,    0,    0,  104,    1,    6,   93,
       58,   84,   60,   82,   62,   83,   19,   49,   64,   85,
       13,   13,    0,    0,    0,    0,   66,   48,   51,   72,

       71,   88,   73,   75,   77,   87,   95,   79,   89,   80,
      103,  114,  114,  102,  100,    7,  110,    0,    0,  114,
      114,   30,  114,  114,  114,  114,  114,  114,   27,   42,
      114,  114,  114,  114,  114,   44,   55,  114,  114,  114,
       23,  114,  114,  114,  114,  114,  101,   69,    2,    3,
        9,   15,   15,    0,    0,    0,   86,   13,   14,    0,
       13,   14,   14,   74,   90,   76,   92,   81,   91,    0,
        0,   15,   41,  114,  114,  114,  114,   33,  114,  114,
       22,   37,   39,  114,   65,  114,   54,  114,   40,  114,
      114,   26,  114,  114,  114,  114,    0,    0,    0,  114,

       31,  114,   29,  114,  114,  114,  114,  114,  114,   28,
       14,   43,  114,  114,   35,    0,    0,    0,   32,  114,
      114,  114,   34,  114,  114,   46,   25,   24,  114,  114,
      114,   38,  114,  114,   45,  114,   36,   47,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    8,    9,   10,   11,
       12,   13,   14,   15,   16,   17,   18,   19,   20,   21,
       21,   21,   21,   21,   21,   22,   22,   23,   24,   25,
       26,   27,    8,   28,   29,   30,   29,   29,   31,   29,
       32,   32,   32,   32,   32,   32,   32,   32,   33,   32,
       32,   32,   32,   32,   32,   32,   32,   34,   32,   32,
       35,   36,   37,   38,   39,   40,   41,   42,   43,   44,

       45,   46,   47,   48,   49,   32,   32,   50,   51,   52,
       53,   54,   32,   55,   56,   57,   58,   59,   60,   61,
       62,   32,   63,   64,   65,   66,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,   32,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,   32,   32,   32,   32,   32,    1,    1,   32,   32,

       32,   32,   32,   32,   32,   32,   32,    1,   32,   32,
       32,   32,   32,   32,    1,    1,   32,   32,   32,   32,
        1,    1,    1,   32,   32,   32,   32,   32,    1,    1,
       32,   32,   32,   32,   32,   32,   32,   32,   32,    1,
       32,   32,   32,   32,   32,   32,    1,    1,   32,   32,
       32,   32,    1,    1,   32
    } ;

static yyconst flex_int32_t yy_meta[67] =
    {   0,
        1,    1,    2,    1,    3,    1,    1,    3,    3,    4,
        1,    1,    3,    3,    1,    3,    3,    3,    5,    5,
        5,    5,    3,    3,    3,    3,    3,    3,    5,    5,
        5,    4,    4,    4,    1,    1,    1,    3,    4,    1,
        5,    5,    5,    5,    5,    5,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    1,    3,    1,    3
    } ;

static yyconst flex_int16_t yy_base[250] =
    {   0,
        0,    0,   64,   65,   66,   67,  286,  765,   77,  278,
       80,  247,  765,  765,    0,  261,  225,   72,  765,   74,
       71,  765,   77,  244,   79,   88,   94,   48,  230,  110,
      106,  117,    0,  136,   65,  240,  765,    0,  140,  203,
      153,  161,  166,  174,  149,   92,  159,  175,  116,  162,
      180,  192,  195,  188,  210,  765,   56,  765,    0,  765,
      765,  221,  219,  765,  765,  765,  216,   96,  216,  145,
      213,    0,    0,    0,  203,  262,  765,  765,  765,  185,
        0,    0,    0,    0,    0,    0,    0,  765,    0,    0,
      244,  257,  132,  271,  248,    0,  765,  765,  765,    0,

        0,    0,  147,  174,    0,    0,    0,    0,    0,  180,
      765,    0,  244,  765,  765,  765,  245,  160,  305,  257,
      261,  260,  278,  285,  288,  292,  300,  304,  314,  317,
      320,  330,  324,  336,  342,  346,  350,  354,  358,  368,
      362,  372,  385,  375,  391,  392,  765,    0,  765,  765,
      765,  765,  179,  435,  168,    0,    0,  439,  232,  443,
      447,  452,    0,    0,    0,    0,    0,    0,    0,  455,
      130,  127,  428,  433,  436,  440,  446,  443,  458,  450,
      462,  466,  463,  478,  470,  484,  483,  490,  491,  497,
      503,  504,  516,  517,  510,  522,  560,    0,  565,  538,

      539,  544,  543,  556,  557,  562,  563,  578,  577,  581,
      582,  585,  595,  599,  598,  135,  130,   91,  602,  605,
      612,  618,  622,  625,  626,  630,  638,  642,  646,  652,
      656,  659,  662,  666,  669,  672,  676,  679,  765,  740,
      745,  114,  750,  752,  757,  107,  759,  101,   96
    } ;

static yyconst flex_int16_t yy_def[250] =
    {   0,
      239,    1,  240,  240,  241,  241,  239,  239,  239,  239,
      239,  242,  239,  239,  242,  242,  243,  239,  239,  242,
      242,  239,  242,  239,  242,  239,  239,  239,  239,  242,
      242,  242,  242,  244,  239,  239,  239,  242,  244,  245,
      244,  244,  244,  244,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,  239,  242,  239,  242,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  242,  242,  242,  239,  239,  239,  239,  239,  242,
      242,  242,  242,  242,  242,  242,  242,  239,  242,  242,
      239,  239,  239,  239,  239,  246,  239,  239,  239,  242,

      242,  242,  242,  242,  242,  242,  242,  242,  242,  242,
      239,  247,   44,  239,  239,  239,   44,  239,  239,   44,
       44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,   44,  239,  242,  239,  239,
      239,  239,  239,  239,  239,  248,  242,  239,  239,  239,
      239,  239,  246,  242,  242,  242,  242,  242,  242,  239,
      239,  239,   44,   44,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,   44,  239,  249,  239,   44,

       44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,  239,  239,  239,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   44,   44,   44,
       44,   44,   44,   44,   44,   44,   44,   44,    0,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239
    } ;

static yyconst flex_int16_t yy_nxt[832] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   16,   17,
       18,   19,   20,   21,   22,   23,   24,   25,   26,   27,
       27,   27,   28,   29,   30,   31,   32,   33,   34,   34,
       34,   34,   34,   34,   35,   36,   37,   38,   39,   40,
       41,   42,   34,   43,   44,   45,   34,   34,   46,   47,
       48,   49,   50,   51,   52,   34,   53,   34,   54,   55,
       34,   34,   56,   57,   58,   59,   61,   61,   65,   65,
       97,   66,   66,   98,   62,   62,   63,   63,   68,   69,
       70,   71,   69,   77,   78,   79,   80,   83,   84,  114,
       81,   82,  147,   85,   86,   89,   90,   68,   69,   70,

      217,   67,   67,   87,   91,  198,   92,   92,   92,   92,
       91,  163,   92,   92,   92,   92,   72,   93,   94,  148,
       95,   96,  105,  106,   94,  100,  101,  102,  115,   93,
      152,  107,   94,  108,  109,  103,  104,  129,   94,  152,
       95,  113,  110,  130,  152,  112,   71,   69,   96,  112,
      159,  159,  113,  111,  112,  112,  112,  112,  112,  112,
      112,  112,  112,  164,  165,  113,  152,  113,  135,  152,
      112,  112,  112,  112,  112,  112,  113,  152,  117,  112,
      112,  112,  112,  112,  112,  112,  112,  112,  152,  126,
      166,  167,  112,  112,  112,  112,  168,  169,  113,  152,

      113,  127,  157,  131,  120,  121,  128,  136,  113,  113,
      113,  113,  152,  113,   71,  132,  137,   71,  122,  113,
      138,  151,  113,  123,  113,  124,  113,  133,  144,  113,
      150,  113,  134,  149,  125,  113,  139,  113,  119,  113,
      113,  113,  140,  113,  113,  116,  113,  141,  113,  142,
      159,  159,  113,   99,   88,  113,  143,  145,  146,  113,
       76,  113,  158,  158,  158,  158,  162,  162,  162,   74,
      113,  153,   73,   91,   94,   92,   92,   92,   92,   71,
      154,  154,  154,  154,  160,  239,  160,   94,   94,  161,
      161,  161,  161,  113,  113,  113,  113,  155,  239,  239,

      173,   94,  239,  155,  113,  113,  113,  174,  113,  113,
      113,  175,  113,  155,  239,  239,  155,  113,  155,  176,
      113,  113,  156,  170,  170,  170,  170,  113,  178,  113,
      179,  239,  239,  177,  113,  239,  113,  113,  113,  113,
      171,  180,  239,  113,  172,  113,  171,  239,  113,  113,
      239,  113,  113,  113,  181,  182,  171,  239,  239,  171,
      113,  171,  239,  113,  113,  113,  113,  185,  113,  113,
      239,  113,  239,  113,  113,  113,  183,  113,  239,  113,
      113,  113,  239,  239,  113,  113,  184,  113,  239,  239,
      113,  113,  186,  113,  239,  113,  113,  113,  187,  113,

      189,  113,  113,  113,  239,  113,  113,  113,  188,  113,
      113,  113,  190,  113,  113,  239,  239,  113,  113,  113,
      239,  113,  113,  113,  194,  239,  113,  239,  113,  191,
      239,  239,  113,  192,  113,  113,  113,  239,  193,  195,
      113,  113,  113,  113,  239,  113,  239,  239,  196,  239,
      239,  113,  113,  197,  197,  197,  197,  158,  158,  158,
      158,  161,  161,  161,  161,  161,  161,  161,  161,   94,
      162,  162,  162,  199,  199,  199,  199,  113,  239,  113,
      201,  200,  113,   94,  113,  113,  239,  113,  113,  113,
      203,  202,  113,  113,  113,  113,  113,  113,  239,  113,

      113,  113,  204,  113,  239,  205,  113,  113,  206,  113,
      113,  113,  113,  113,  113,  113,  239,  113,  113,  113,
      207,  113,  113,  113,  208,  239,  113,  113,  239,  113,
      113,  239,  113,  113,  113,  113,  239,  239,  113,  113,
      113,  113,  113,  113,  113,  209,  113,  211,  210,  239,
      113,  113,  113,  113,  113,  113,  239,  113,  239,  214,
      212,  113,  239,  113,  113,  113,  113,  113,  113,  215,
      113,  113,  239,  113,  213,  239,  113,  113,  216,  216,
      216,  216,  113,  218,  218,  218,  218,  113,  113,  219,
      113,  239,  113,  113,  113,  113,  239,  239,  113,  113,

      220,  211,  239,  113,  113,  113,  113,  113,  113,  221,
      223,  113,  113,  113,  113,  239,  113,  113,  222,  224,
      239,  225,  113,  113,  239,  239,  113,  113,  113,  113,
      113,  113,  113,  113,  113,  239,  113,  113,  113,  226,
      239,  113,  113,  227,  113,  113,  113,  113,  113,  113,
      113,  113,  239,  113,  113,  113,  113,  228,  113,  113,
      239,  113,  113,  113,  239,  113,  230,  113,  229,  113,
      239,  113,  113,  113,  231,  113,  113,  113,  113,  113,
      232,  113,  113,  239,  239,  113,  113,  113,  239,  113,
      113,  113,  239,  113,  233,  113,  239,  113,  113,  239,

      235,  113,  113,  113,  234,  113,  113,  113,  113,  239,
      113,  113,  113,  113,  236,  113,  113,  237,  113,  113,
      113,  113,  113,  238,  239,  113,  113,  113,  113,  113,
      113,  239,  113,  239,  239,  239,  113,  239,  239,  113,
       60,   60,   60,   60,   60,   64,   64,   64,   64,   64,
       75,  239,   75,   75,   75,  113,  113,  118,  239,  118,
      118,  118,  112,  112,    7,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,

      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239
    } ;

static yyconst flex_int16_t yy_chk[832] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    4,    5,    6,
       28,    5,    6,   28,    3,    4,    3,    4,    9,    9,
        9,   11,   11,   18,   18,   20,   20,   21,   21,   35,
       20,   20,   57,   23,   23,   25,   25,   68,   68,   68,

      249,    5,    6,   23,   26,  248,   26,   26,   26,   26,
       27,  246,   27,   27,   27,   27,  242,   26,   26,   57,
       26,   26,   31,   31,   27,   30,   30,   30,   35,   26,
      218,   31,   26,   32,   32,   30,   30,   46,   27,  217,
       26,   46,   32,   46,  216,   34,   70,   70,   26,   39,
       93,   93,   46,   32,   34,   34,   34,   34,   39,   39,
       39,   39,   41,  103,  103,   49,  172,   49,   49,  171,
       42,   41,   41,   41,   41,   43,   49,  155,   39,   42,
       42,   42,   42,   44,   43,   43,   43,   43,  153,   45,
      104,  104,   44,   44,   44,   44,  110,  110,   45,  118,

       45,   45,   80,   47,   41,   42,   45,   50,   47,   45,
       47,   50,   75,   50,   71,   48,   50,   69,   43,   47,
       51,   67,   50,   44,   48,   44,   48,   48,   54,   51,
       63,   51,   48,   62,   44,   48,   52,   54,   40,   54,
       51,   52,   53,   52,   53,   36,   53,   53,   54,   53,
      159,  159,   52,   29,   24,   53,   53,   55,   55,   55,
       17,   55,   91,   91,   91,   91,   95,   95,   95,   16,
       55,   76,   12,   92,   91,   92,   92,   92,   92,   10,
       76,   76,   76,   76,   94,    7,   94,   92,   91,   94,
       94,   94,   94,  113,  117,  113,  117,   76,    0,    0,

      120,   92,    0,   76,  113,  117,  120,  121,  120,  122,
      121,  122,  121,   76,    0,    0,   76,  120,   76,  122,
      122,  121,   76,  119,  119,  119,  119,  123,  124,  123,
      125,    0,    0,  123,  124,    0,  124,  125,  123,  125,
      119,  126,    0,  126,  119,  124,  119,    0,  125,  127,
        0,  127,  126,  128,  127,  128,  119,    0,    0,  119,
      127,  119,    0,  129,  128,  129,  130,  133,  130,  131,
        0,  131,    0,  133,  129,  133,  131,  130,    0,  132,
      131,  132,    0,    0,  133,  134,  132,  134,    0,    0,
      132,  135,  134,  135,    0,  136,  134,  136,  135,  137,

      139,  137,  135,  138,    0,  138,  136,  139,  138,  139,
      137,  141,  140,  141,  138,    0,    0,  140,  139,  140,
        0,  142,  141,  142,  144,    0,  144,    0,  140,  142,
        0,    0,  142,  142,  143,  144,  143,    0,  143,  145,
      145,  146,  145,  146,    0,  143,    0,    0,  146,    0,
        0,  145,  146,  154,  154,  154,  154,  158,  158,  158,
      158,  160,  160,  160,  160,  161,  161,  161,  161,  158,
      162,  162,  162,  170,  170,  170,  170,  173,    0,  173,
      175,  174,  174,  158,  174,  175,    0,  175,  173,  176,
      177,  176,  178,  174,  178,  177,  175,  177,    0,  180,

      176,  180,  179,  178,    0,  180,  177,  179,  182,  179,
      180,  181,  183,  181,  183,  182,    0,  182,  179,  185,
      184,  185,  181,  183,  186,    0,  182,  184,    0,  184,
      185,    0,  187,  186,  187,  186,    0,    0,  184,  188,
      189,  188,  189,  187,  186,  188,  190,  191,  190,    0,
      188,  189,  191,  192,  191,  192,    0,  190,    0,  195,
      193,  195,    0,  191,  192,  193,  194,  193,  194,  196,
      195,  196,    0,  196,  194,    0,  193,  194,  197,  197,
      197,  197,  196,  199,  199,  199,  199,  200,  201,  200,
      201,    0,  203,  202,  203,  202,    0,    0,  200,  201,

      202,  205,    0,  203,  202,  204,  205,  204,  205,  204,
      207,  206,  207,  206,  207,    0,  204,  205,  206,  208,
        0,  209,  206,  207,    0,    0,  209,  208,  209,  208,
      210,  211,  210,  211,  212,    0,  212,  209,  208,  213,
        0,  210,  211,  214,  213,  212,  213,  215,  214,  215,
      214,  219,    0,  219,  220,  213,  220,  220,  215,  214,
        0,  221,  219,  221,    0,  220,  222,  222,  221,  222,
        0,  223,  221,  223,  224,  225,  224,  225,  222,  226,
      225,  226,  223,    0,    0,  224,  225,  227,    0,  227,
      226,  228,    0,  228,  229,  229,    0,  229,  227,    0,

      231,  230,  228,  230,  230,  231,  229,  231,  232,    0,
      232,  233,  230,  233,  233,  234,  231,  234,  235,  232,
      235,  236,  233,  236,    0,  237,  234,  237,  238,  235,
      238,    0,  236,    0,    0,    0,  237,    0,    0,  238,
      240,  240,  240,  240,  240,  241,  241,  241,  241,  241,
      243,    0,  243,  243,  243,  244,  244,  245,    0,  245,
      245,  245,  247,  247,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,

      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239,  239,  239,  239,  239,  239,  239,  239,  239,  239,
      239
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int zz_flex_debug;
int zz_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *zztext;
#include <stdlib.h>
#include "CamlIndenter.h"

static int d = 0;

int printtoken(int a, int b, int tk);
extern int leading;
extern int trailing;
extern int newline;
extern char* token_start;
extern size_t token_length;
extern size_t currentPos;

#define YY_USER_ACTION {token_length += zzleng; currentPos += zzleng;}

#define INITIAL 0
#define COM 1
#define STR 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int zzlex_destroy (void );

int zzget_debug (void );

void zzset_debug (int debug_flag  );

YY_EXTRA_TYPE zzget_extra (void );

void zzset_extra (YY_EXTRA_TYPE user_defined  );

FILE *zzget_in (void );

void zzset_in  (FILE * in_str  );

FILE *zzget_out (void );

void zzset_out  (FILE * out_str  );

yy_size_t zzget_leng (void );

char *zzget_text (void );

int zzget_lineno (void );

void zzset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int zzwrap (void );
#else
extern int zzwrap (void );
#endif
#endif

    //static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif
/*
#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif
#endif
*/
/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO fwrite( zztext, zzleng, 1, zzout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( zzin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( zzin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, zzin))==0 && ferror(zzin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(zzin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int zzlex (void);

#define YY_DECL int zzlex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after zztext and zzleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! zzin )
			zzin = stdin;

		if ( ! zzout )
			zzout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			zzensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				zz_create_buffer(zzin,YY_BUF_SIZE );
		}

		zz_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of zztext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = (YY_CHAR)yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 240 )
					yy_c = (YY_CHAR)yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 765 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
{ BEGIN(COM); d = 1; token_start = zztext; token_length = 2; }
	YY_BREAK
case 2:
YY_RULE_SETUP
{d++;}
	YY_BREAK
case 3:
YY_RULE_SETUP
{d--; if (d == 0) { BEGIN(INITIAL); return printtoken(1, 1, COMMENT2);}}
	YY_BREAK
case 4:
/* rule 4 can match eol */
YY_RULE_SETUP

	YY_BREAK
case 5:
YY_RULE_SETUP

	YY_BREAK
case YY_STATE_EOF(COM):
{ BEGIN(INITIAL); return printtoken(1, 1, COMMENT2);}
	YY_BREAK
case 6:
YY_RULE_SETUP
printtoken(1, 1, OTHER2);
	YY_BREAK
case 7:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 8:
YY_RULE_SETUP
{BEGIN(STR); token_start = zztext; token_length = 1;}
	YY_BREAK
case 9:
YY_RULE_SETUP

	YY_BREAK
case 10:
YY_RULE_SETUP
{BEGIN(INITIAL); return printtoken(1, 1, STRING2);}
	YY_BREAK
case 11:
YY_RULE_SETUP

	YY_BREAK
case YY_STATE_EOF(STR):
{BEGIN(INITIAL); return printtoken(1, 1, STRING2);}	
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
{newline++; leading = 0; trailing = 0;}
	YY_BREAK
case 13:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 14:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 15:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 16:
YY_RULE_SETUP

	YY_BREAK
case 17:
YY_RULE_SETUP
{return printtoken(1, 0, LEFTPAR2);}
	YY_BREAK
case 18:
YY_RULE_SETUP
{return printtoken(0, 1, RIGHTPAR2);}
	YY_BREAK
case 19:
YY_RULE_SETUP
{return printtoken(1, 1, RIGHTARROW2);}
	YY_BREAK
case 20:
YY_RULE_SETUP
{return printtoken(1, 1, EQUAL2);}
	YY_BREAK
case 21:
YY_RULE_SETUP
{return printtoken(1, 1, BAR2);}
	YY_BREAK
case 22:
YY_RULE_SETUP
{return printtoken(1, 1, FOR2);}
	YY_BREAK
case 23:
YY_RULE_SETUP
{return printtoken(1, 1, TO2);}
	YY_BREAK
case 24:
YY_RULE_SETUP
{return printtoken(1, 1, TO2);}
	YY_BREAK
case 25:
YY_RULE_SETUP
{return printtoken(1, 1, WHILE2);}
	YY_BREAK
case 26:
YY_RULE_SETUP
{return printtoken(1, 1, TRY2);}
	YY_BREAK
case 27:
YY_RULE_SETUP
{return printtoken(1, 1, IF2);}
	YY_BREAK
case 28:
YY_RULE_SETUP
{return printtoken(1, 1, THEN2);}
	YY_BREAK
case 29:
YY_RULE_SETUP
{return printtoken(1, 1, ELSE2);}
	YY_BREAK
case 30:
YY_RULE_SETUP
{return printtoken(1, 1, DO2);}
	YY_BREAK
case 31:
YY_RULE_SETUP
{return printtoken(1, 1, DONE2);}
	YY_BREAK
case 32:
YY_RULE_SETUP
{return printtoken(1, 1, BEGIN2);}
	YY_BREAK
case 33:
YY_RULE_SETUP
{return printtoken(1, 1, END2);}
	YY_BREAK
case 34:
YY_RULE_SETUP
{return printtoken(1, 1, MATCH2);}
	YY_BREAK
case 35:
YY_RULE_SETUP
{return printtoken(1, 1, WITH2);}
	YY_BREAK
case 36:
YY_RULE_SETUP
{return printtoken(1, 1, FUNCTION2);}
	YY_BREAK
case 37:
YY_RULE_SETUP
{return printtoken(1, 1, FUN2);}
	YY_BREAK
case 38:
YY_RULE_SETUP
{return printtoken(1, 1, PARSER2);}
	YY_BREAK
case 39:
YY_RULE_SETUP
{return printtoken(1, 1, LET2);}
	YY_BREAK
case 40:
YY_RULE_SETUP
{return printtoken(1, 1, REC2);}
	YY_BREAK
case 41:
YY_RULE_SETUP
{return printtoken(1, 1, AND2);}
	YY_BREAK
case 42:
YY_RULE_SETUP
{return printtoken(1, 1, IN2);}
	YY_BREAK
case 43:
YY_RULE_SETUP
{return printtoken(1, 1, TYPE2);}
	YY_BREAK
case 44:
YY_RULE_SETUP
{return printtoken(1, 1, OF2);}
	YY_BREAK
case 45:
YY_RULE_SETUP
{return printtoken(1, 1, MUTABLE2);}
	YY_BREAK
case 46:
YY_RULE_SETUP
{return printtoken(1, 1, IGNORE2);}
	YY_BREAK
case 47:
YY_RULE_SETUP
{return printtoken(1, 1, IGNORE2);}
	YY_BREAK
case 48:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 49:
YY_RULE_SETUP
{return printtoken(0, 0, DOTPAR2);}
	YY_BREAK
case 50:
YY_RULE_SETUP
{return printtoken(0, 1, SEP2);}
	YY_BREAK
case 51:
YY_RULE_SETUP
{return printtoken(0, 0, ENDMARK2);}
	YY_BREAK
case 52:
YY_RULE_SETUP
{return printtoken(1, 0, OTHER2);}
	YY_BREAK
case 53:
YY_RULE_SETUP
{return printtoken(0, 1, OTHER2);}
	YY_BREAK
case 54:
case 55:
case 56:
case 57:
case 58:
case 59:
case 60:
case 61:
case 62:
case 63:
case 64:
case 65:
case 66:
case 67:
case 68:
case 69:
case 70:
case 71:
case 72:
case 73:
case 74:
case 75:
case 76:
case 77:
case 78:
case 79:
case 80:
case 81:
case 82:
case 83:
case 84:
case 85:
case 86:
case 87:
case 88:
case 89:
case 90:
case 91:
case 92:
case 93:
case 94:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 95:
YY_RULE_SETUP
{return printtoken(1, 1, EQUALEQUAL2);}
	YY_BREAK
case 96:
YY_RULE_SETUP
{return printtoken(1, 0, LEFTBRACE2);}
	YY_BREAK
case 97:
YY_RULE_SETUP
{return printtoken(0, 1, RIGHTBRACE2);}
	YY_BREAK
case 98:
YY_RULE_SETUP
{return printtoken(1, 0, LEFTPAR2);}
	YY_BREAK
case 99:
YY_RULE_SETUP
{return printtoken(0, 1, RIGHTPAR2);}
	YY_BREAK
case 100:
YY_RULE_SETUP
{return printtoken(1, 0, LEFTPAR2);}
	YY_BREAK
case 101:
YY_RULE_SETUP
{return printtoken(0, 1, RIGHTPAR2);}
	YY_BREAK
case 102:
YY_RULE_SETUP
{return printtoken(1, 0, LSTREAM2);}
	YY_BREAK
case 103:
YY_RULE_SETUP
{return printtoken(0, 1, RSTREAM2);}
	YY_BREAK
case 104:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 105:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 106:
YY_RULE_SETUP
{return printtoken(1, 0, IGNORE2);}
	YY_BREAK
case 107:
YY_RULE_SETUP
{return printtoken(0, 0, OTHER2);}
	YY_BREAK
case 108:
YY_RULE_SETUP
{return printtoken(0, 1, COLON2);}
	YY_BREAK
case 109:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 110:
YY_RULE_SETUP
{return printtoken(0, 0, OTHER2);}
	YY_BREAK
case 111:
YY_RULE_SETUP
{return printtoken(1, 0, OTHER2);}
	YY_BREAK
case 112:
YY_RULE_SETUP
{return printtoken(1, 0, OTHER2);}	
	YY_BREAK
case 113:
YY_RULE_SETUP
{return printtoken(1, 1, OTHER2);}
	YY_BREAK
case 114:
YY_RULE_SETUP
{return printtoken(1, 1, IDEN2);}
	YY_BREAK
case 115:
YY_RULE_SETUP
{return printtoken(0, 0, OTHER2);}
	YY_BREAK
case YY_STATE_EOF(INITIAL):

			BEGIN(INITIAL);
            return 0;

	YY_BREAK
case 116:
YY_RULE_SETUP
ECHO;
	YY_BREAK

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed zzin at a new source and called
			 * zzlex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = zzin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

//				if ( zzwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * zztext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}
/*
				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
*/
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of zzlex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					zzrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			zzrestart(zzin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) zzrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (YY_CHAR)(*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 240 )
				yy_c = (YY_CHAR)yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 240 )
			yy_c = (YY_CHAR)yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 239);

	return yy_is_jam ? 0 : yy_current_state;
}
/*
    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

        // undo effects of setting up zztext
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
                { // need to shift things up to make room
                 +2 for EOB chars.
		register yy_size_t number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}
*/
/*
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		// yy_c_buf_p now points to the character we want to return.
        // If this occurs *before* the EOB characters, then it's a
        // valid NUL; if not, then we've hit the end of the buffer.
		 
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			// This was really a NUL.
			*(yy_c_buf_p) = '\0';

		else
			{ // need more input
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					// This happens because yy_g_n_b()
                    // sees that we've accumulated a
                    // token and flags that we need to
                    // try matching the token before
                    // proceeding.  But for input(),
                    // there's no matching to consider.
                    // So convert the EOB_ACT_LAST_MATCH
                    // to EOB_ACT_END_OF_FILE.

					// Reset buffer status.
					zzrestart(zzin );

					//FALLTHROUGH

				case EOB_ACT_END_OF_FILE:
					{
//					if ( zzwrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	// cast for 8-bit char's
	*(yy_c_buf_p) = '\0';	// preserve zztext
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	// ifndef YY_NO_INPUT
*/

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void zzrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        zzensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            zz_create_buffer(zzin,YY_BUF_SIZE );
	}

	zz_init_buffer(YY_CURRENT_BUFFER,input_file );
	zz_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void zz_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		zzpop_buffer_state();
	 *		zzpush_buffer_state(new_buffer);
     */
	zzensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	zz_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (zzwrap()) processing, but the only time this flag
	 * is looked at is after zzwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void zz_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	zzin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE zz_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) zzalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in zz_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) zzalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in zz_create_buffer()" );

	b->yy_is_our_buffer = 1;

	zz_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with zz_create_buffer()
 * 
 */
    void zz_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		zzfree((void *) b->yy_ch_buf  );

	zzfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a zzrestart() or at EOF.
 */
    static void zz_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	zz_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then zz_init_buffer was _probably_
     * called from zzrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        //b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
		b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void zz_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		zz_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void zzpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	zzensure_buffer_stack();

	/* This block is copied from zz_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from zz_switch_to_buffer. */
	zz_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void zzpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	zz_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		zz_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void zzensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)zzalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in zzensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)zzrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in zzensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE zz_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) zzalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in zz_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	zz_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to zzlex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       zz_scan_bytes() instead.
 */
YY_BUFFER_STATE zz_scan_string (yyconst char * yystr )
{
    
	return zz_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to zzlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE zz_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n, i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) zzalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in zz_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = zz_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in zz_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up zztext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		zztext[zzleng] = (yy_hold_char); \
		(yy_c_buf_p) = zztext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		zzleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int zzget_lineno  (void)
{
        
    return zzlineno;
}

/** Get the input stream.
 * 
 */
FILE *zzget_in  (void)
{
        return zzin;
}

/** Get the output stream.
 * 
 */
FILE *zzget_out  (void)
{
        return zzout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t zzget_leng  (void)
{
        return zzleng;
}

/** Get the current token.
 * 
 */

char *zzget_text  (void)
{
        return zztext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void zzset_lineno (int  line_number )
{
    
    zzlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see zz_switch_to_buffer
 */
void zzset_in (FILE *  in_str )
{
        zzin = in_str ;
}

void zzset_out (FILE *  out_str )
{
        zzout = out_str ;
}

int zzget_debug  (void)
{
        return zz_flex_debug;
}

void zzset_debug (int  bdebug )
{
        zz_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from zzlex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    zzin = stdin;
    zzout = stdout;
#else
    zzin = (FILE *) 0;
    zzout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * zzlex_init()
     */
    return 0;
}

/* zzlex_destroy is for both reentrant and non-reentrant scanners. */
int zzlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		zz_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		zzpop_buffer_state();
	}

	/* Destroy the stack itself. */
	zzfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * zzlex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *zzalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *zzrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void zzfree (void * ptr )
{
	free( (char *) ptr );	/* see zzrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"

int printtoken(int a, int b, int tk)
{
	leading = a;
	trailing = b;
	return tk;
}
