/*
Program WinCaml: Graphical User Interface
for interactive use of Caml-Light and Ocaml.
Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
email: jean.mouric@orange.fr

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File CSplitter.h

#include "platform.h"

class CSplitter : public CSplitterBase
{
	CRichEdit* richEdit1;
	CRichEdit* richEdit2;

	bool xMove;
	int xPos;
	int xPos0;

	bool yMove;
	int yPos;
	int yPos0;

	int viewMode;
	int xAdjust(int xSplit);
	int yAdjust(int ySplit);
	void resize();
	bool movingHorizontally();
	bool movingVertically();
public:
	int xSplit;
	int xDim;
	int ySplit;
	int yDim;

	CSplitter(CChildFrame* cfr, CRichEdit* re1, CRichEdit* re2, int paneVisibility,
		int xSplit, int xDim, int ySplit, int yDim, bool verticalSplitBar);
	~CSplitter();
	void onLeftButtonDown(int posx, int posy);
	void onLeftButtonUp();
	void onMouseMove(int posx, int posy, bool mouseDown);
	void setVertical(bool verticalBar);
	void setViewMode(int mode);
	void zoom();
};
