/*
Program WinCaml: Graphical User Interface
for interactive use of Caml-Light and Ocaml.
Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
email: jean.mouric@orange.fr

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File CInput.h

#include "platform.h"

class CChildFrame;
class CHighlighter;
class CUndoManager;

class CInput : public CRichEdit
{
	void onLeftButtonUp(bool ctrlDown);
	void beginPrint();
	void endPrint();
	void onKeyDown();
	void onEnterKeyDown();
	void onReturnKeyDown();
	void onKeyUp();

	size_t bufferStart;
	wstring replacedText;
	wstring replacingText;
	wstring previousString;
public:
	CInput(CChildFrame* cfr);
	~CInput();        
	void commandRange();
	void addCommands(wstring str);
	void sendCommand();
    //void sendSelection();
	void undo();
	void redo();
	void indent();
	void onReplace(const wstring& replaceWith);
    void onReplaceAll(const wstring& findWhat, const wstring& replaceWith, unsigned long flags = 0L);
	void setColors();
	void setColor(int colorType);
	void removeColors();
	wstring status();
    void replace(size_t a, size_t l, wstring s);
	void replaceSelection(wstring s);
	void setSelection(size_t selStart, size_t selEnd);
	void doCopy();
	void doCut();
	void doPaste();

	CUndoManager* undoManager;
	CChildFrame* cChildFrame;
	void textHasChanged();
};

