/*
 Program WinCaml: Graphical User Interface
 for interactive use of Caml-Light and Ocaml.
 Copyright (C) 2005-2017 Jean Mouric 35700 Rennes France
 email: jean.mouric@orange.fr
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

// File CChildFrame.h

#include "platform.h"

enum{CAMLLIGHT, OCAML};

class CFrame;
class CHighlighter;
class CInput;
class COutput;
class CProcess;
class CSplitter;

class CommandInfo
{
public:
	size_t start;
	bool expanded;
};

class CChildFrame : public CMDIChildFrame
{
	//COutput* cOutput;
	CSplitter* splitter;
	bool isNewFile;
    
	void setConfig();
	void updateCamlMenu(bool sendEnabled);
	void onClose();
	void onDestroy();
	void onFileSaveAs();
	void onFileSaveAsFormatted();
	void onSize();
	void onLeftButtonDown(int x, int y);
	void onLeftButtonUp();
	void onEditCut();
	void onEditCopy();
	void onEditPaste();
	void onEditSelectAll();
	void onCommand(int cmd);
	void onTimer();
	void updateMenus(bool activating);
	void includeFile();
    void setStatus();
public:
	deque<wstring>* commandArray;
	deque<CommandInfo>* commandInfoArray;
	CInput* cInput;
	COutput* cOutput;
	CFrame* cFrame;
    
	CProcess* process;
	unsigned int currentCommand;
	CFont *font1, *font2;
    
	bool IndentWithTabs;
	bool IndentAfterIn;
	bool IndentFilters;
	bool UseOCamlIndenter;
	int SpaceCountPerTab;
    
	bool VerticalBar;
	int xDim;
	int xSplit;
	int yDim;
	int ySplit;
    
	int InputFontSize;
	int OutputFontSize;
    
	wstring InputFontName;
	wstring OutputFontName;
    
	bool WrapInput;
	bool WrapOutput;
    
	int SplitterViewMode;
    
	bool SyntaxColoring;
    
	int OutputMode;
    
	unsigned long InputBufferBackground;
	unsigned long InputCommandBackground;
	unsigned long OutputCommandForeground;
	unsigned long NumberColor;
	unsigned long KeywordColor;
	unsigned long DelimiterColor;
	unsigned long OperatorColor;
	unsigned long StringColor;
	unsigned long CommentColor;
	unsigned long OtherColor;
    
	int PreferredEncoding;
	bool AutomaticEncoding;
    
	int CamlTop;
	bool StartNow;
    
	//--------------------------------------------
    
	CChildFrame(CFrame* mdiFrame, bool maximized);
	~CChildFrame();
	void onFileSave();
	void newFile();
	void onActivate();
	void onMouseMove(int x, int y, bool leftButtonDown);
	bool openFile(const wstring& szFileName);
	void restore();
	bool reviewChange();
	void startProcess(const wstring& s = L"");
	void reset(int p);
	void updateUndoMenuTitle();
	void updateRedoMenuTitle();
	void updateCopyAndCutMenus();
};


