#!/bin/sh

# wxWidgets, mingw


# Pour pouvoir ensuite utiliser ce script:

# 1) installer la distribution source wxWidgets-x.y.z et la compiler en ligne de commande "msys" en y entrant:

# ./configure --disable-shared
# make

# ou:

# ./configure
# make


# 2) adapter ci-dessous les variables WXPATH (chemin de la distribution wxWidgets) WXVERSION (version de wxWidgets), WXVER et TOOLCHAIN (outils mingw)
# WXVER=2.9 pour la version 2.9.5, WXVER=3.0 pour la version 3.0.x
# les outils mingw doivent tre ceux qui ont servi pour compiler wxWidgets
 

WXVERSION=3.0.0
WXVER=3.0
WXPATH=/c/wxWidgets-$WXVERSION
#TOOLCHAIN=/c/mingw/bin
TOOLCHAIN=/c/mingw64/bin


PATH=/bin:/c/Windows/System32:$TOOLCHAIN

if [ -d $WXPATH/lib/wx/include/msw-unicode-static-$WXVER ]; then
	WXSETUPDIR=$WXPATH/lib/wx/include/msw-unicode-static-$WXVER
	DEFINES="-D__WXMSW__ -D_MINGW_ -DWX_PRECOMP"
	LINKOPTS="-static-libgcc -static-libstdc++ -mwindows -mthreads"
	WXSTATIC=1
elif [ -d $WXPATH/lib/wx/include/msw-unicode-$WXVER ]; then
	WXSETUPDIR=$WXPATH/lib/wx/include/msw-unicode-$WXVER
	DEFINES="-D__WXMSW__ -D_MINGW_ -DWX_PRECOMP -DWXUSINGDLL"
	LINKOPTS="-mwindows -mthreads"
	WXSTATIC=0
else
	echo "wxWidgets setup.h not found"
	exit 1
fi

INCLUDES="-I. -I$WXSETUPDIR -I$WXPATH/include"
OPTS="-Wall -Wundef -Wunused-parameter -Wno-ctor-dtor-privacy -Woverloaded-virtual -O2 -mthreads -fno-strict-aliasing"
WINCAMLBASE=../../..

g++ -c $DEFINES $OPTS $INCLUDES  $WINCAMLBASE/sources/wx/*.cpp $WINCAMLBASE/sources/All/*.cpp

windres $WINCAMLBASE/sources/wx/resources/WinCaml.rc WinCamlres.o


WXLIBS="-lwx_mswu_stc-$WXVER -lwx_mswu_core-$WXVER -lwx_baseu-$WXVER -lwxscintilla-$WXVER -lwxpng-$WXVER -lwxzlib-$WXVER -lwxregexu-$WXVER -lwxexpat-$WXVER" 
WINLIBS="-lrpcrt4 -loleaut32 -lole32 -luuid -lwinspool -lwinmm -lshell32 -lcomctl32 -lcomdlg32 -ladvapi32 -lwsock32 -lgdi32 -lshlwapi"

g++ -o WinCaml.exe *.o $LINKOPTS -L$WXPATH/lib $WXLIBS $WINLIBS
strip WinCaml.exe


rm *.o
test -d WinCaml5 || mkdir WinCaml5
test -d WinCaml5/ocaml || mkdir WinCaml5/ocaml
mv WinCaml WinCaml5
cp $WINCAMLBASE/sources/Win/WinCamlInit.bat WinCaml5
cp -Rf $WINCAMLBASE/caml/ocaml/windows WinCaml5/ocaml
cp -Rf $WINCAMLBASE/caml/ocaml/htmlman WinCaml5/ocaml
cp -Rf $WINCAMLBASE/caml/caml-light  WinCaml5
rm -f WinCaml5/caml-light/bin/lin*
rm -f WinCaml5/caml-light/bin/mac*
cp -Rf $WINCAMLBASE/caml/exemples WinCaml5

if [ $WXSTATIC = 0 ]; then
	cp $TOOLCHAIN/libgcc_s_*.dll WinCaml5
	cp $TOOLCHAIN/libstdc++*.dll WinCaml5
	SAVEDIR=`pwd`
	cd $WXPATH/lib
	cp `ls $WXPATH/lib | egrep '(wxbase|wxmsw)[^_]*(_|_core_|_stc_)gcc_custom.dll'` $SAVEDIR/WinCaml5
fi

