@echo off

rem Adapter ci-dessous les variables WXVERSION (version de wxWidgets), WXVER et WXBASE (chemin de la distribution wxWidgets)

rem WXVER=29 pour la version 2.9.5 et WXVER=30 pour la version 3.0.x


set VCID=%1


if "%2" == "32" (
	echo architecture 32 bits
	if "%ProgramFiles(x86)%" == "" (
		call "C:\Program Files\Microsoft Visual Studio %VCID%.0\VC\bin\vcvars32.bat"
	) else (
		call "%ProgramFiles(x86)%\Microsoft Visual Studio %VCID%.0\VC\bin\vcvars32.bat"
	)
	set ARCH=x86
) else if "%2" == "64" (
	echo architecture 64 bits
	if "%VCID%" == "9" (
		call "%ProgramFiles(x86)%\Microsoft Visual Studio %VCID%.0\VC\bin\vcvarsx86_amd64.bat"
	) else (
		call "%ProgramFiles(x86)%\Microsoft Visual Studio %VCID%.0\VC\vcvarsall.bat" x86_amd64
	)
	set ARCH=x64
) else (
	echo Syntaxe: msb vcid archi  avec vcid = 9, 10 ou 11 et archi = 32 ou 64
	goto END
)


set WXVERSION=2.9.5
set WXVER=29
set WXBASE="%HOMEPATH%\wxWidgets-vc%VCID%-%WXVERSION%"


set DEFINES=/D WIN32 /D _CRT_SECURE_NO_DEPRECATE=1 /D _CRT_NON_CONFORMING_SWPRINTFS=1 /D _SCL_SECURE_NO_WARNINGS=1 /D __WXMSW__ /D NDEBUG /D _WINDOWS /D NOPCH /D _UNICODE /D UNICODE
set WXLIBS=wxmsw%WXVER%u_stc.lib wxmsw%WXVER%u_core.lib wxbase%WXVER%u.lib wxscintilla.lib wxtiff.lib wxjpeg.lib wxpng.lib wxzlib.lib wxregexu.lib wxexpat.lib
set WINLIBS=kernel32.lib user32.lib gdi32.lib comdlg32.lib winspool.lib winmm.lib shell32.lib comctl32.lib ole32.lib oleaut32.lib uuid.lib rpcrt4.lib advapi32.lib wsock32.lib wininet.lib odbc32.lib odbccp32.lib shlwapi.lib
set LINKOPTIONS=/INCREMENTAL:NO /NOLOGO /SUBSYSTEM:WINDOWS /DYNAMICBASE /NXCOMPAT /MANIFEST /MANIFESTFILE:".\temp.manifest" /MANIFESTUAC:"level='asInvoker' uiAccess='false'" /MACHINE:%ARCH%
set WINCAMLBASE=.\..\..\..
if exist "%WXBASE%\lib\vc_%ARCH%_lib\" (set "WXVCLIB=vc_%ARCH%_lib") else (set WXVCLIB=vc_lib)
cl.exe /O2 %DEFINES% /EHsc /MD /Fo".\\" /W3 /c /TP /I%WXBASE%\lib\%WXVCLIB%\mswu /I%WXBASE%\include  %WINCAMLBASE%\sources\wx\*.cpp %WINCAMLBASE%\sources\All\*.cpp
rc.exe /fo ".\WinCaml.res" "%WINCAMLBASE%\sources\wx\resources\WinCaml.rc"
link.exe /OUT:".\WinCaml.exe" %LINKOPTIONS% /LIBPATH:%WXBASE%\lib\%WXVCLIB% %WXLIBS% %WINLIBS% ".\WinCaml.res" ".\*.obj"
mt.exe /outputresource:".\WinCaml.exe;#1" /manifest ".\temp.manifest" /nologo"


del .\*.obj
del .\*.res
del .\temp.manifest

xcopy /q /s /y /i %WINCAMLBASE%\caml\ocaml\windows WinCaml5\ocaml\windows\
move /y WinCaml.exe WinCaml5
copy %WINCAMLBASE%\sources\Win\WinCamlInit.bat WinCaml5
xcopy /q /s /y /i %WINCAMLBASE%\caml\ocaml\htmlman WinCaml5\ocaml\htmlman\
xcopy /q /s /y /i %WINCAMLBASE%\caml\"caml-light"  WinCaml5\"caml-light"\
del WinCaml5\"caml-light"\bin\lin*
del WinCaml5\caml-light"\bin\mac*
xcopy /q /s /y /i %WINCAMLBASE%\caml\exemples WinCaml5\exemples\


:END