/*
 Program WinCaml: Graphical User Interface
 for interactive use of Caml-Light and Ocaml.
 Copyright (C) 2005-2015 Jean Mouric 35700 Rennes France
 email: jean.mouric@orange.fr
 
 This program is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File lex.tt.cpp

#include <string>
extern size_t currentPos;


#define YY_NO_UNISTD_H
#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define yy_create_buffer tt_create_buffer
#define yy_delete_buffer tt_delete_buffer
#define yy_flex_debug tt_flex_debug
#define yy_init_buffer tt_init_buffer
#define yy_flush_buffer tt_flush_buffer
#define yy_load_buffer_state tt_load_buffer_state
#define yy_switch_to_buffer tt_switch_to_buffer
#define yyin ttin
#define yyleng ttleng
#define yylex ttlex
#define yylineno ttlineno
#define yyout ttout
#define yyrestart ttrestart
#define yytext tttext
#define yywrap ttwrap
#define yyalloc ttalloc
#define yyrealloc ttrealloc
#define yyfree ttfree

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 5
#define YY_FLEX_SUBMINOR_VERSION 35
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;
#endif /* ! C99 */

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#endif /* ! FLEXINT_H */

#ifdef __cplusplus

/* The "const" storage-class-modifier is valid. */
#define YY_USE_CONST

#else	/* ! __cplusplus */

/* C99 requires __STDC__ to be defined as 1. */
#if defined (__STDC__)

#define YY_USE_CONST

#endif	/* defined (__STDC__) */
#endif	/* ! __cplusplus */

#ifdef YY_USE_CONST
#define yyconst const
#else
#define yyconst
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an unsigned
 * integer for use as an array index.  If the signed char is negative,
 * we want to instead treat it as an 8-bit unsigned char, hence the
 * double cast.
 */
#define YY_SC_TO_UI(c) ((unsigned int) (unsigned char) c)

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN (yy_start) = 1 + 2 *

/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START (((yy_start) - 1) / 2)
#define YYSTATE YY_START

/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)

/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE ttrestart(ttin  )

#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#define YY_BUF_SIZE 16384
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

extern yy_size_t ttleng;

extern FILE *ttin, *ttout;

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2

    #define YY_LESS_LINENO(n)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up tttext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = (yy_hold_char); \
		YY_RESTORE_YY_MORE_OFFSET \
		(yy_c_buf_p) = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up tttext again */ \
		} \
	while ( 0 )

#define unput(c) yyunput( c, (yytext_ptr)  )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	yy_size_t yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	yy_size_t yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */
    
	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via ttrestart()), so that the user can continue scanning by
	 * just pointing ttin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* Stack of input buffers. */
static size_t yy_buffer_stack_top = 0; /**< index of top of stack. */
static size_t yy_buffer_stack_max = 0; /**< capacity of stack. */
static YY_BUFFER_STATE * yy_buffer_stack = 0; /**< Stack as an array. */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( (yy_buffer_stack) \
                          ? (yy_buffer_stack)[(yy_buffer_stack_top)] \
                          : NULL)

/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE (yy_buffer_stack)[(yy_buffer_stack_top)]

/* yy_hold_char holds the character lost when tttext is formed. */
static char yy_hold_char;
static yy_size_t yy_n_chars;		/* number of characters read into yy_ch_buf */
yy_size_t ttleng;

/* Points to current character in buffer. */
static char *yy_c_buf_p = (char *) 0;
static int yy_init = 0;		/* whether we need to initialize */
static int yy_start = 0;	/* start state number */

/* Flag which is used to allow ttwrap()'s to do buffer switches
 * instead of setting up a fresh ttin.  A bit of a hack ...
 */
static int yy_did_buffer_switch_on_eof;

void ttrestart (FILE *input_file  );
void tt_switch_to_buffer (YY_BUFFER_STATE new_buffer  );
YY_BUFFER_STATE tt_create_buffer (FILE *file,int size  );
void tt_delete_buffer (YY_BUFFER_STATE b  );
void tt_flush_buffer (YY_BUFFER_STATE b  );
void ttpush_buffer_state (YY_BUFFER_STATE new_buffer  );
void ttpop_buffer_state (void );

static void ttensure_buffer_stack (void );
static void tt_load_buffer_state (void );
static void tt_init_buffer (YY_BUFFER_STATE b,FILE *file  );

#define YY_FLUSH_BUFFER tt_flush_buffer(YY_CURRENT_BUFFER )

YY_BUFFER_STATE tt_scan_buffer (char *base,yy_size_t size  );
YY_BUFFER_STATE tt_scan_string (yyconst char *yy_str  );
YY_BUFFER_STATE tt_scan_bytes (yyconst char *bytes,yy_size_t len  );

void *ttalloc (yy_size_t  );
void *ttrealloc (void *,yy_size_t  );
void ttfree (void *  );

#define yy_new_buffer tt_create_buffer

#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        ttensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            tt_create_buffer(ttin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}

#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        ttensure_buffer_stack (); \
		YY_CURRENT_BUFFER_LVALUE =    \
            tt_create_buffer(ttin,YY_BUF_SIZE ); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}

#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define ttwrap(n) 1
#define YY_SKIP_YYWRAP

typedef unsigned char YY_CHAR;

FILE *ttin = (FILE *) 0, *ttout = (FILE *) 0;

typedef int yy_state_type;

extern int ttlineno;

int ttlineno = 1;

extern char *tttext;
#define yytext_ptr tttext

static yy_state_type yy_get_previous_state (void );
static yy_state_type yy_try_NUL_trans (yy_state_type current_state  );
static int yy_get_next_buffer (void );
static void yy_fatal_error (yyconst char msg[]  );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up tttext.
 */
#define YY_DO_BEFORE_ACTION \
	(yytext_ptr) = yy_bp; \
	ttleng = (size_t) (yy_cp - yy_bp); \
	(yy_hold_char) = *yy_cp; \
	*yy_cp = '\0'; \
	(yy_c_buf_p) = yy_cp;

#define YY_NUM_RULES 100
#define YY_END_OF_BUFFER 101
/* This struct is not used in this scanner,
   but its presence is necessary. */
struct yy_trans_info
	{
	flex_int32_t yy_verify;
	flex_int32_t yy_nxt;
	};
static yyconst flex_int16_t yy_accept[304] =
    {   0,
        0,    0,    0,    0,    0,    0,  101,  100,   20,   12,
       12,   19,    7,   93,   18,   96,   21,   22,   18,   77,
       18,   94,   13,   13,   95,   75,   18,   18,   99,   83,
      100,   84,   98,   97,   98,   98,   98,   98,   98,   98,
       98,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   81,   18,   82,    4,    4,    4,   11,    8,   11,
       20,   12,   12,   12,   19,   18,    0,    0,    0,   80,
        1,    5,   16,   74,   13,   13,    0,    0,    0,    0,
       78,   18,   92,   76,   17,   88,   90,   99,    0,   87,
       91,   79,   85,    6,   98,    0,    0,   98,   49,   98,

       98,   98,   31,   98,   98,   98,   98,   98,   98,   28,
       43,   98,   98,   98,   98,   98,   98,   98,   98,   98,
       98,   98,   45,   98,   18,   98,   98,   98,   98,   98,
       98,   24,   98,   98,   98,   98,   98,   98,   89,   86,
        2,    3,    9,   10,   15,   15,    0,    0,    0,   13,
       14,    0,   13,   14,   14,    0,    0,   15,   42,   98,
       98,   98,   98,   98,   98,   98,   34,   98,   98,   98,
       23,   38,   98,   98,   98,   98,   98,   40,   98,   98,
       98,   18,   98,   66,   98,   98,   98,   98,   41,   69,
       98,   98,   98,   27,   98,   47,   98,   98,   98,   98,

        0,    0,    0,   98,   98,   98,   98,   32,   98,   30,
       98,   98,   98,   98,   98,   98,   98,   61,   98,   98,
       98,   98,   98,   67,   98,   98,   98,   29,   50,   44,
       48,   98,   72,   98,   36,    0,    0,    0,   98,   33,
       53,   98,   98,   98,   98,   51,   98,   98,   98,   98,
       35,   98,   98,   98,   98,   98,   98,   98,   98,   26,
       52,   98,   25,   98,   98,   98,   98,   98,   98,   98,
       62,   64,   98,   65,   39,   98,   70,   98,   98,   98,
       98,   98,   56,   57,   58,   98,   63,   46,   68,   71,
       98,   98,   55,   37,   59,   98,   98,   73,   98,   54,

       98,   60,    0
    } ;

static yyconst flex_int32_t yy_ec[256] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    2,    3,
        1,    1,    4,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    2,    5,    6,    7,    8,    8,    9,   10,   11,
       12,   13,   14,   15,   16,   17,    8,   18,   19,   20,
       20,   20,   20,   20,   20,   21,   21,   22,   23,   24,
       25,   26,   27,    8,   28,   29,   28,   28,   30,   28,
       31,   31,   31,   31,   31,   31,   31,   31,   32,   31,
       31,   31,   31,   31,   31,   31,   31,   33,   31,   31,
       34,   35,   36,    8,   37,   38,   39,   40,   41,   42,

       43,   44,   45,   46,   47,   48,   37,   49,   50,   51,
       52,   53,   37,   54,   55,   56,   57,   58,   59,   60,
       61,   62,   63,   64,   65,   66,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,   31,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,   31,   31,   31,   31,   31,    1,    1,   31,   31,

       31,   31,   31,   31,   31,   31,   31,    1,   31,   31,
       31,   31,   31,   31,    1,    1,   31,   31,   31,   31,
        1,    1,    1,   37,   37,   37,   37,   37,    1,    1,
       37,   37,   37,   37,   37,   37,   37,   37,   37,    1,
       37,   37,   37,   37,   37,   37,    1,    1,   37,   37,
       37,   37,    1,    1,   37
    } ;

static yyconst flex_int32_t yy_meta[67] =
    {   0,
        1,    1,    2,    1,    3,    1,    1,    3,    3,    4,
        1,    1,    3,    3,    1,    3,    3,    5,    5,    5,
        5,    3,    1,    3,    3,    3,    3,    5,    5,    5,
        4,    4,    4,    1,    1,    1,    4,    1,    5,    5,
        5,    5,    5,    5,    4,    4,    4,    4,    4,    4,
        4,    4,    4,    4,    4,    4,    4,    4,    4,    4,
        4,    4,    1,    3,    1,    1
    } ;

static yyconst flex_int16_t yy_base[315] =
    {   0,
        0,    0,   64,   65,   66,   67,  450,  451,   77,  447,
       80,    0,  451,  451,    0,  413,   72,  451,  435,  451,
      420,  428,  120,   69,   69,  421,  427,   35,    0,   90,
      436,  451,    0,  406,   42,  397,   54,  387,   47,   65,
       64,   91,   66,  395,   91,   71,  394,   64,   67,   85,
      101,  412,  399,  451,  451,  421,  421,  451,  451,  121,
      155,  430,  159,  429,    0,    0,  420,  171,  153,  451,
      451,  451,    0,  451,  155,  183,  148,  200,  150,    0,
      451,  451,  451,  451,    0,  451,  451,    0,  169,  451,
      451,  451,  176,  451,    0,  391,  223,  386,  128,  382,

      387,  374,  128,  369,  381,  143,  373,  367,  369,    0,
      147,  135,  363,  364,  161,  365,  360,  359,  372,  357,
      353,  363,    0,  367,    0,  355,  361,  366,  361,  351,
      361,    0,   72,  350,  353,  347,  181,  344,  451,  451,
      451,  451,  451,  451,  451,  389,  216,  388,    0,  227,
      177,  231,  235,  189,    0,  246,  359,  358,    0,  352,
      347,  338,  337,  348,  339,  346,    0,  345,  344,  331,
        0,  344,  335,  340,  326,  339,  319,    0,  325,  337,
      331,  319,  336,    0,  331,  322,  317,  313,    0,    0,
      313,  318,  325,    0,  324,  361,  309,  313,  314,  316,

      262,    0,  266,  307,  309,  304,  302,    0,  301,    0,
      303,  301,  311,  297,  295,  297,  303,    0,  303,  296,
      298,  306,  304,    0,  301,  304,  301,    0,    0,    0,
      451,  284,    0,  297,    0,  329,  328,  299,  280,    0,
        0,  281,  282,  277,  281,    0,  221,  289,  283,  290,
        0,  286,  284,  277,  269,  270,  267,  266,  282,    0,
        0,  281,    0,  272,  279,  265,  262,  272,  258,  264,
      307,    0,  265,    0,    0,  256,    0,  229,  229,  223,
      223,  220,    0,    0,  264,  215,  451,    0,    0,    0,
      209,  208,    0,    0,  451,  177,  182,    0,  189,    0,

      176,    0,  451,  287,  292,  226,  220,  297,  299,  301,
      306,  172,  159,  137
    } ;

static yyconst flex_int16_t yy_def[315] =
    {   0,
      303,    1,  304,  304,  305,  305,  303,  303,  303,  303,
      303,  306,  303,  303,  307,  308,  303,  303,  307,  303,
      307,  303,  303,  303,  303,  303,  307,  307,  309,  303,
      303,  303,  310,  311,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  303,  307,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  306,  307,  303,  303,  303,  303,
      303,  303,  307,  303,  303,  303,  303,  303,  303,  312,
      303,  303,  303,  303,  307,  303,  303,  309,  303,  303,
      303,  303,  303,  303,  310,  303,  303,  310,  310,  310,

      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  313,  303,
      303,  303,  303,  303,  312,  303,  303,  303,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,

      303,  314,  303,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      303,  310,  310,  310,  310,  303,  303,  303,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  310,  310,  310,  310,
      310,  310,  310,  310,  310,  310,  303,  310,  310,  310,
      310,  310,  310,  310,  303,  310,  310,  310,  310,  310,

      310,  310,    0,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303
    } ;

static yyconst flex_int16_t yy_nxt[518] =
    {   0,
        8,    9,   10,   11,   12,   13,   14,   15,   15,   16,
       17,   18,   19,   15,   20,   21,   22,   23,   24,   24,
       24,   25,   26,   27,   15,   28,   12,   29,   29,   29,
       29,   29,   29,   30,   31,   32,   33,   34,   35,   36,
       37,   38,   39,   40,   33,   33,   41,   33,   42,   43,
       44,   45,   46,   47,   48,   49,   33,   50,   51,   33,
       33,   33,   52,   53,   54,   12,    8,    8,    8,    8,
       86,   59,   59,   69,   56,   56,   57,   57,   61,   62,
       63,   64,   62,   70,   71,   75,   76,   76,   76,   76,
       81,   89,   98,   82,   83,  104,   99,  105,   78,   87,

       60,   60,  101,  107,  117,  102,  106,  110,  118,  126,
      129,   78,  131,   90,  111,   91,  108,  119,  132,  130,
      133,  109,  120,  135,  127,   92,  143,  134,  193,  112,
      122,  136,  194,  113,  123,   69,   75,   76,   76,   76,
       76,  237,  114,  124,  125,  115,  137,  138,   77,   78,
      116,   79,   80,   93,   69,  144,   61,   62,   63,   77,
       64,   62,   78,  202,   70,  151,  151,  154,  154,  154,
       89,   79,  150,  150,  150,  150,  155,   89,  164,   80,
      146,  125,  160,  168,   78,  176,  165,  173,  147,  147,
      147,  147,  174,  175,  151,  151,  177,   78,  169,   75,

       76,   76,   76,   76,   92,  148,  154,  154,  154,  125,
      148,   92,   78,  152,  125,  152,   69,  153,  153,  153,
      153,  148,   66,  198,  148,   78,  148,  199,   65,  302,
      149,  301,   89,  201,  201,  201,  201,  300,  299,   89,
      156,  156,  156,  156,  150,  150,  150,  150,  153,  153,
      153,  153,  153,  153,  153,  153,   78,  157,  298,  297,
      158,  296,  157,  203,  203,  203,  203,  266,  295,   78,
      294,  293,  267,  157,  292,  291,  157,  290,  157,  236,
      236,  236,  236,  238,  238,  238,  238,   55,   55,   55,
       55,   55,   58,   58,   58,   58,   58,   67,  289,   67,

       67,   67,   88,   88,   95,   95,   96,  288,   96,   96,
       96,  287,  286,  285,  284,  283,  282,  281,  280,  279,
      278,  277,  276,  275,  274,  273,  272,  271,  270,  269,
      268,  265,  264,  263,  262,  261,  145,  145,  145,  260,
      259,  258,  257,  256,  255,  254,  253,  252,  251,  250,
      249,  248,  247,  246,  245,  244,  243,  242,  241,  240,
      239,  235,  234,  233,  232,  231,  230,  229,  228,  227,
      226,  225,  224,  223,  222,  221,  220,  219,  125,  218,
      125,  217,  216,  215,  214,  213,  212,  211,  210,  209,
      208,  207,  206,  205,  204,  145,  145,  145,  145,  200,

      197,  196,  195,  192,  191,  190,  189,  188,  187,  186,
      185,  184,  183,  182,  181,  180,  179,  125,  178,  172,
      171,  170,  167,  166,  163,  162,  161,  159,  145,  145,
       64,   64,  142,  141,  140,  139,  128,  121,  103,  100,
       97,   94,   85,   84,   74,   73,   72,   68,   64,  303,
        7,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303
    } ;

static yyconst flex_int16_t yy_chk[518] =
    {   0,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    1,    1,    1,    1,
        1,    1,    1,    1,    1,    1,    3,    4,    5,    6,
       28,    5,    6,   17,    3,    4,    3,    4,    9,    9,
        9,   11,   11,   17,   17,   24,   24,   24,   24,   24,
       25,   30,   35,   25,   25,   39,   35,   39,   24,   28,

        5,    6,   37,   40,   43,   37,   39,   41,   43,   46,
       48,   24,   49,   30,   41,   30,   40,   43,   49,   48,
       49,   40,   43,   50,   46,   30,   60,   49,  133,   42,
       45,   50,  133,   42,   45,   17,   23,   23,   23,   23,
       23,  314,   42,   45,   45,   42,   51,   51,   23,   23,
       42,   23,   23,   30,   69,   60,   61,   61,   61,   23,
       63,   63,   23,  313,   69,   77,   77,   79,   79,   79,
       89,   23,   75,   75,   75,   75,  312,   93,  103,   23,
       68,   99,   99,  106,   75,  112,  103,  111,   68,   68,
       68,   68,  111,  111,  151,  151,  112,   75,  106,   76,

       76,   76,   76,   76,   89,   68,  154,  154,  154,  115,
       68,   93,   76,   78,  115,   78,   69,   78,   78,   78,
       78,   68,  307,  137,   68,   76,   68,  137,  306,  301,
       68,  299,   89,  147,  147,  147,  147,  297,  296,   93,
       97,   97,   97,   97,  150,  150,  150,  150,  152,  152,
      152,  152,  153,  153,  153,  153,  150,   97,  292,  291,
       97,  286,   97,  156,  156,  156,  156,  247,  285,  150,
      282,  281,  247,   97,  280,  279,   97,  278,   97,  201,
      201,  201,  201,  203,  203,  203,  203,  304,  304,  304,
      304,  304,  305,  305,  305,  305,  305,  308,  276,  308,

      308,  308,  309,  309,  310,  310,  311,  273,  311,  311,
      311,  271,  270,  269,  268,  267,  266,  265,  264,  262,
      259,  258,  257,  256,  255,  254,  253,  252,  250,  249,
      248,  245,  244,  243,  242,  239,  238,  237,  236,  234,
      232,  227,  226,  225,  223,  222,  221,  220,  219,  217,
      216,  215,  214,  213,  212,  211,  209,  207,  206,  205,
      204,  200,  199,  198,  197,  196,  195,  193,  192,  191,
      188,  187,  186,  185,  183,  182,  181,  180,  179,  177,
      176,  175,  174,  173,  172,  170,  169,  168,  166,  165,
      164,  163,  162,  161,  160,  158,  157,  148,  146,  138,

      136,  135,  134,  131,  130,  129,  128,  127,  126,  124,
      122,  121,  120,  119,  118,  117,  116,  114,  113,  109,
      108,  107,  105,  104,  102,  101,  100,   98,   96,   67,
       64,   62,   57,   56,   53,   52,   47,   44,   38,   36,
       34,   31,   27,   26,   22,   21,   19,   16,   10,    7,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,

      303,  303,  303,  303,  303,  303,  303,  303,  303,  303,
      303,  303,  303,  303,  303,  303,  303
    } ;

static yy_state_type yy_last_accepting_state;
static char *yy_last_accepting_cpos;

extern int tt_flex_debug;
int tt_flex_debug = 0;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
char *tttext;
#include <stdlib.h>
#include <string.h>
#include "OCamlIndenter.h"

static int d = 0;
extern int leading;
extern int trailing;
extern int newline;
extern char* token_start;
extern size_t token_length;
extern size_t currentPos;

#define YY_USER_ACTION {token_length += ttleng; currentPos += ttleng;}

#define INITIAL 0
#define COM 1
#define STR 2

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

static int yy_init_globals (void );

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int ttlex_destroy (void );

int ttget_debug (void );

void ttset_debug (int debug_flag  );

YY_EXTRA_TYPE ttget_extra (void );

void ttset_extra (YY_EXTRA_TYPE user_defined  );

FILE *ttget_in (void );

void ttset_in  (FILE * in_str  );

FILE *ttget_out (void );

void ttset_out  (FILE * out_str  );

yy_size_t ttget_leng (void );

char *ttget_text (void );

int ttget_lineno (void );

void ttset_lineno (int line_number  );

/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int ttwrap (void );
#else
extern int ttwrap (void );
#endif
#endif

    //static void yyunput (int c,char *buf_ptr  );
    
#ifndef yytext_ptr
static void yy_flex_strncpy (char *,yyconst char *,int );
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * );
#endif
/*
#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput (void );
#else
static int input (void );
#endif
#endif
*/
/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#define YY_READ_BUF_SIZE 8192
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
   we now use fwrite(). */

#define ECHO fwrite( tttext, ttleng, 1, ttout )
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
   is returned in "result". */

#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		yy_size_t n; \
		for ( n = 0; n < max_size && \
			     (c = getc( ttin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( ttin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = fread(buf, 1, max_size, ttin))==0 && ferror(ttin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(ttin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg )
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int ttlex (void);

#define YY_DECL int ttlex (void)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after tttext and ttleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	register yy_state_type yy_current_state;
	register char *yy_cp, *yy_bp;
	register int yy_act;
    
	if ( !(yy_init) )
		{
		(yy_init) = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! (yy_start) )
			(yy_start) = 1;	/* first start state */

		if ( ! ttin )
			ttin = stdin;

		if ( ! ttout )
			ttout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			ttensure_buffer_stack ();
			YY_CURRENT_BUFFER_LVALUE =
				tt_create_buffer(ttin,YY_BUF_SIZE );
		}

		tt_load_buffer_state( );
		}

	while ( 1 )		/* loops until end-of-file is reached */
		{
		yy_cp = (yy_c_buf_p);

		/* Support of tttext. */
		*yy_cp = (yy_hold_char);

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = (yy_start);
yy_match:
		do
			{
			register YY_CHAR yy_c = (YY_CHAR)yy_ec[YY_SC_TO_UI(*yy_cp)];
			if ( yy_accept[yy_current_state] )
				{
				(yy_last_accepting_state) = yy_current_state;
				(yy_last_accepting_cpos) = yy_cp;
				}
			while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
				{
				yy_current_state = (int) yy_def[yy_current_state];
				if ( yy_current_state >= 304 )
					yy_c = (YY_CHAR)yy_meta[(unsigned int) yy_c];
				}
			yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
			++yy_cp;
			}
		while ( yy_base[yy_current_state] != 451 );

yy_find_action:
		yy_act = yy_accept[yy_current_state];
		if ( yy_act == 0 )
			{ /* have to back up */
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			yy_act = yy_accept[yy_current_state];
			}

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
			case 0: /* must back up */
			/* undo the effects of YY_DO_BEFORE_ACTION */
			*yy_cp = (yy_hold_char);
			yy_cp = (yy_last_accepting_cpos);
			yy_current_state = (yy_last_accepting_state);
			goto yy_find_action;

case 1:
YY_RULE_SETUP
{ BEGIN(COM); d = 1; token_start = tttext; token_length = 2; }
	YY_BREAK
case 2:
YY_RULE_SETUP
{d++;}
	YY_BREAK
case 3:
YY_RULE_SETUP
{d--; if (d == 0) { BEGIN(INITIAL); leading = 1; trailing = 1; return COMMENT;}}
	YY_BREAK
case 4:
YY_RULE_SETUP

	YY_BREAK
case YY_STATE_EOF(COM):
{ BEGIN(INITIAL); leading = 1; trailing = 1; return COMMENT;}
	YY_BREAK
case 5:
YY_RULE_SETUP
{leading = 1; trailing = 1; return OTHER;}
	YY_BREAK
case 6:
YY_RULE_SETUP
{leading = 1; trailing = 1; return OTHER;}
	YY_BREAK
case 7:
YY_RULE_SETUP
{BEGIN(STR); token_start = tttext; token_length = 1;}
	YY_BREAK
case 8:
YY_RULE_SETUP
{BEGIN(INITIAL); leading = 1; trailing = 1; return STRING;}
	YY_BREAK
case 9:
YY_RULE_SETUP

	YY_BREAK
case 10:
YY_RULE_SETUP

	YY_BREAK
case 11:
YY_RULE_SETUP

	YY_BREAK
case YY_STATE_EOF(STR):
{BEGIN(INITIAL); leading = 1; trailing = 1; return STRING;}	
	YY_BREAK
case 12:
/* rule 12 can match eol */
YY_RULE_SETUP
{newline++; leading = 0; trailing = 0;}
	YY_BREAK
case 13:
YY_RULE_SETUP
{leading = 1; trailing = 1; return FLOAT;}
	YY_BREAK
case 14:
YY_RULE_SETUP
{leading = 1; trailing = 1; return INTEGER;}
	YY_BREAK
case 15:
YY_RULE_SETUP
{leading = 1; trailing = 1; return CHAR;}
	YY_BREAK
case 16:
YY_RULE_SETUP
{leading = 1; trailing = 1; return RIGHTARROW;}
	YY_BREAK
case 17:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LEFTARROW;}
	YY_BREAK
case 18:
YY_RULE_SETUP
{leading = 1; trailing = 1; return INFIX_SYMBOL;}
	YY_BREAK
case 19:
YY_RULE_SETUP
{leading = 1; if (strcmp("!=", tttext)){trailing = 0; return PREFIX_SYMBOL;} else {trailing = 1; return INFIX_SYMBOL;}}
	YY_BREAK
case 20:
YY_RULE_SETUP
{}
	YY_BREAK
case 21:
YY_RULE_SETUP
{leading = 1; trailing = 0; return LPAR;}
	YY_BREAK
case 22:
YY_RULE_SETUP
{leading = 0; trailing = 1; return RPAR;}
	YY_BREAK
case 23:
YY_RULE_SETUP
{leading = 1; trailing = 1; return FOR;}
	YY_BREAK
case 24:
YY_RULE_SETUP
{leading = 1; trailing = 1; return TO;}
	YY_BREAK
case 25:
YY_RULE_SETUP
{leading = 1; trailing = 1; return DOWNTO;}
	YY_BREAK
case 26:
YY_RULE_SETUP
{leading = 1; trailing = 1; return WHILE;}
	YY_BREAK
case 27:
YY_RULE_SETUP
{leading = 1; trailing = 1; return TRY1;}
	YY_BREAK
case 28:
YY_RULE_SETUP
{leading = 1; trailing = 1; return IF;}
	YY_BREAK
case 29:
YY_RULE_SETUP
{leading = 1; trailing = 1; return THEN;}
	YY_BREAK
case 30:
YY_RULE_SETUP
{leading = 1; trailing = 1; return ELSE;}
	YY_BREAK
case 31:
YY_RULE_SETUP
{leading = 1; trailing = 1; return DO;}
	YY_BREAK
case 32:
YY_RULE_SETUP
{leading = 1; trailing = 1; return DONE;}
	YY_BREAK
case 33:
YY_RULE_SETUP
{leading = 1; trailing = 1; return BEGIN1;}
	YY_BREAK
case 34:
YY_RULE_SETUP
{leading = 1; trailing = 1; return END;}
	YY_BREAK
case 35:
YY_RULE_SETUP
{leading = 1; trailing = 1; return MATCH;}
	YY_BREAK
case 36:
YY_RULE_SETUP
{leading = 1; trailing = 1; return WITH;}
	YY_BREAK
case 37:
YY_RULE_SETUP
{leading = 1; trailing = 1; return FUNCTION;}
	YY_BREAK
case 38:
YY_RULE_SETUP
{leading = 1; trailing = 1; return FUN;}
	YY_BREAK
case 39:
YY_RULE_SETUP
{leading = 1; trailing = 1; return PARSER;}
	YY_BREAK
case 40:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LET;}
	YY_BREAK
case 41:
YY_RULE_SETUP
{leading = 1; trailing = 1; return REC;}
	YY_BREAK
case 42:
YY_RULE_SETUP
{leading = 1; trailing = 1; return AND;}
	YY_BREAK
case 43:
YY_RULE_SETUP
{leading = 1; trailing = 1; return IN1;}
	YY_BREAK
case 44:
YY_RULE_SETUP
{leading = 1; trailing = 1; return TYPE;}
	YY_BREAK
case 45:
YY_RULE_SETUP
{leading = 1; trailing = 1; return OF;}
	YY_BREAK
case 46:
YY_RULE_SETUP
{leading = 1; trailing = 1; return MUTABLE;}
	YY_BREAK
case 47:
YY_RULE_SETUP
{leading = 1; trailing = 1; return VAL;}
	YY_BREAK
case 48:
YY_RULE_SETUP
{leading = 1; trailing = 1; return VAL;}
	YY_BREAK
case 49:
YY_RULE_SETUP
{leading = 1; trailing = 1; return AS;}
	YY_BREAK
case 50:
YY_RULE_SETUP
{leading = 1; trailing = 1; return BOOLVALUE;}
	YY_BREAK
case 51:
YY_RULE_SETUP
{leading = 1; trailing = 1; return BOOLVALUE;}
	YY_BREAK
case 52:
YY_RULE_SETUP
{leading = 1; trailing = 1; return ASSERT1;}
	YY_BREAK
case 53:
YY_RULE_SETUP
{leading = 1; trailing = 1; return CLASS;}
	YY_BREAK
case 54:
YY_RULE_SETUP
{leading = 1; trailing = 1; return CONSTRAINT;}
	YY_BREAK
case 55:
YY_RULE_SETUP
{leading = 1; trailing = 1; return EXTERNAL;}
	YY_BREAK
case 56:
YY_RULE_SETUP
{leading = 1; trailing = 1; return FUNCTOR;}
	YY_BREAK
case 57:
YY_RULE_SETUP
{leading = 1; trailing = 1; return INCLUDE;}
	YY_BREAK
case 58:
YY_RULE_SETUP
{leading = 1; trailing = 1; return INHERIT;}
	YY_BREAK
case 59:
YY_RULE_SETUP
{leading = 1; trailing = 1; return INHERIT;}
	YY_BREAK
case 60:
YY_RULE_SETUP
{leading = 1; trailing = 1; return INITIALIZER;}
	YY_BREAK
case 61:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LAZY;}
	YY_BREAK
case 62:
YY_RULE_SETUP
{leading = 1; trailing = 1; return METHOD1;}
	YY_BREAK
case 63:
YY_RULE_SETUP
{leading = 1; trailing = 1; return METHOD1;}
	YY_BREAK
case 64:
YY_RULE_SETUP
{leading = 1; trailing = 1; return MODULE;}
	YY_BREAK
case 65:
YY_RULE_SETUP
{leading = 1; trailing = 1; return OBJECT;}
	YY_BREAK
case 66:
YY_RULE_SETUP
{leading = 1; trailing = 1; return NEW;}
	YY_BREAK
case 67:
YY_RULE_SETUP
{leading = 1; trailing = 1; return OPEN;}
	YY_BREAK
case 68:
YY_RULE_SETUP
{leading = 1; trailing = 1; return PRIVATE;}
	YY_BREAK
case 69:
YY_RULE_SETUP
{leading = 1; trailing = 1; return SIG;}
	YY_BREAK
case 70:
YY_RULE_SETUP
{leading = 1; trailing = 1; return STRUCT;}
	YY_BREAK
case 71:
YY_RULE_SETUP
{leading = 1; trailing = 1; return VIRTUAL;}
	YY_BREAK
case 72:
YY_RULE_SETUP
{leading = 1; trailing = 1; return WHEN;}
	YY_BREAK
case 73:
YY_RULE_SETUP
{leading = 1; trailing = 1; return EXCEPTION;}
	YY_BREAK
case 74:
YY_RULE_SETUP
{leading = 0; trailing = 0; return DOTDOT;}
	YY_BREAK
case 75:
YY_RULE_SETUP
{leading = 0; trailing = 1; return SEMICOLON;}
	YY_BREAK
case 76:
YY_RULE_SETUP
{leading = 0; trailing = 0; return ENDMARK;}
	YY_BREAK
case 77:
YY_RULE_SETUP
{leading = 0; trailing = 1; return COMMA;}
	YY_BREAK
case 78:
YY_RULE_SETUP
{leading = 1; trailing = 1; return COLONCOLON;}
	YY_BREAK
case 79:
YY_RULE_SETUP
{leading = 1; trailing = 1; return EMPTYLIST;}
	YY_BREAK
case 80:
YY_RULE_SETUP
{leading = 1; trailing = 1; return UNIT;}
	YY_BREAK
case 81:
YY_RULE_SETUP
{leading = 1; trailing = 0; return LBRACE;}
	YY_BREAK
case 82:
YY_RULE_SETUP
{leading = 0; trailing = 1; return RBRACE;}
	YY_BREAK
case 83:
YY_RULE_SETUP
{leading = 1; trailing = 0; return LBRACKET;}
	YY_BREAK
case 84:
YY_RULE_SETUP
{leading = 0; trailing = 1; return RBRACKET;}
	YY_BREAK
case 85:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LLIST;}
	YY_BREAK
case 86:
YY_RULE_SETUP
{leading = 1; trailing = 1; return RLIST;}
	YY_BREAK
case 87:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LSTREAM;}
	YY_BREAK
case 88:
YY_RULE_SETUP
{leading = 1; trailing = 1; return RSTREAM;}
	YY_BREAK
case 89:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LOBJECT;}
	YY_BREAK
case 90:
YY_RULE_SETUP
{leading = 1; trailing = 1; return ROBJECT;}
	YY_BREAK
case 91:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LBRACKETSUP;}
	YY_BREAK
case 92:
YY_RULE_SETUP
{leading = 1; trailing = 1; return COLONSUP;}
	YY_BREAK
case 93:
YY_RULE_SETUP
{leading = 0; trailing = 0; return SHARP;}
	YY_BREAK
case 94:
YY_RULE_SETUP
{leading = 0; trailing = 0; return DOT;}
	YY_BREAK
case 95:
YY_RULE_SETUP
{leading = 0; trailing = 1; return COLON;}
	YY_BREAK
case 96:
YY_RULE_SETUP
{leading = 1; trailing = 1; return QUOTE;}
	YY_BREAK
case 97:
YY_RULE_SETUP
{leading = 1; trailing = 0; return BACKQUOTE;}
	YY_BREAK
case 98:
YY_RULE_SETUP
{leading = 1; trailing = 1; return LOWERCASE_IDENT;}
	YY_BREAK
case 99:
YY_RULE_SETUP
{leading = 1; trailing = 1; return CAPITALIZED_IDENT;}
	YY_BREAK
case YY_STATE_EOF(INITIAL):

			BEGIN(INITIAL);
            return 0;

	YY_BREAK
case 100:
YY_RULE_SETUP
ECHO;
	YY_BREAK

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - (yytext_ptr)) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = (yy_hold_char);
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed ttin at a new source and called
			 * ttlex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = ttin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( (yy_c_buf_p) <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			(yy_c_buf_p) = (yytext_ptr) + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state(  );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state );

			yy_bp = (yytext_ptr) + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++(yy_c_buf_p);
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = (yy_c_buf_p);
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer(  ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				(yy_did_buffer_switch_on_eof) = 0;

//				if ( ttwrap( ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * tttext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					(yy_c_buf_p) = (yytext_ptr) + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}
/*
				else
					{
					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
					}
*/
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				(yy_c_buf_p) =
					(yytext_ptr) + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				(yy_c_buf_p) =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)];

				yy_current_state = yy_get_previous_state(  );

				yy_cp = (yy_c_buf_p);
				yy_bp = (yytext_ptr) + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
} /* end of ttlex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (void)
{
    	register char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	register char *source = (yytext_ptr);
	register int number_to_move, i;
	int ret_val;

	if ( (yy_c_buf_p) > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( (yy_c_buf_p) - (yytext_ptr) - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) ((yy_c_buf_p) - (yytext_ptr)) - 1;

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars) = 0;

	else
		{
			yy_size_t num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER;

			int yy_c_buf_p_offset =
				(int) ((yy_c_buf_p) - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				yy_size_t new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					ttrealloc((void *) b->yy_ch_buf,b->yy_buf_size + 2  );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = 0;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			(yy_c_buf_p) = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			(yy_n_chars), num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	if ( (yy_n_chars) == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			ttrestart(ttin  );
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yy_size_t) ((yy_n_chars) + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		yy_size_t new_size = (yy_n_chars) + number_to_move + ((yy_n_chars) >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) ttrealloc((void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf,new_size  );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
	}

	(yy_n_chars) += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars) + 1] = YY_END_OF_BUFFER_CHAR;

	(yytext_ptr) = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (void)
{
	register yy_state_type yy_current_state;
	register char *yy_cp;
    
	yy_current_state = (yy_start);

	for ( yy_cp = (yytext_ptr) + YY_MORE_ADJ; yy_cp < (yy_c_buf_p); ++yy_cp )
		{
		register YY_CHAR yy_c = (YY_CHAR)(*yy_cp ? yy_ec[YY_SC_TO_UI(*yy_cp)] : 1);
		if ( yy_accept[yy_current_state] )
			{
			(yy_last_accepting_state) = yy_current_state;
			(yy_last_accepting_cpos) = yy_cp;
			}
		while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
			{
			yy_current_state = (int) yy_def[yy_current_state];
			if ( yy_current_state >= 304 )
				yy_c = (YY_CHAR)yy_meta[(unsigned int) yy_c];
			}
		yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state )
{
	register int yy_is_jam;
    	register char *yy_cp = (yy_c_buf_p);

	register YY_CHAR yy_c = 1;
	if ( yy_accept[yy_current_state] )
		{
		(yy_last_accepting_state) = yy_current_state;
		(yy_last_accepting_cpos) = yy_cp;
		}
	while ( yy_chk[yy_base[yy_current_state] + yy_c] != yy_current_state )
		{
		yy_current_state = (int) yy_def[yy_current_state];
		if ( yy_current_state >= 304 )
			yy_c = (YY_CHAR)yy_meta[(unsigned int) yy_c];
		}
	yy_current_state = yy_nxt[yy_base[yy_current_state] + (unsigned int) yy_c];
	yy_is_jam = (yy_current_state == 303);

	return yy_is_jam ? 0 : yy_current_state;
}
/*
    static void yyunput (int c, register char * yy_bp )
{
	register char *yy_cp;
    
    yy_cp = (yy_c_buf_p);

        // undo effects of setting up tttext
	*yy_cp = (yy_hold_char);

	if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
                { // need to shift things up to make room
                // +2 for EOB chars.
		register yy_size_t number_to_move = (yy_n_chars) + 2;
		register char *dest = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[
					YY_CURRENT_BUFFER_LVALUE->yy_buf_size + 2];
		register char *source =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move];

		while ( source > YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			*--dest = *--source;

		yy_cp += (int) (dest - source);
		yy_bp += (int) (dest - source);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars =
			(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_buf_size;

		if ( yy_cp < YY_CURRENT_BUFFER_LVALUE->yy_ch_buf + 2 )
			YY_FATAL_ERROR( "flex scanner push-back overflow" );
		}

	*--yy_cp = (char) c;

	(yytext_ptr) = yy_bp;
	(yy_hold_char) = *yy_cp;
	(yy_c_buf_p) = yy_cp;
}
*/
/*
#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (void)
#else
    static int input  (void)
#endif

{
	int c;
    
	*(yy_c_buf_p) = (yy_hold_char);

	if ( *(yy_c_buf_p) == YY_END_OF_BUFFER_CHAR )
		{
		// yy_c_buf_p now points to the character we want to return.
        // If this occurs *before* the EOB characters, then it's a
        // valid NUL; if not, then we've hit the end of the buffer.
		 
		if ( (yy_c_buf_p) < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[(yy_n_chars)] )
			// This was really a NUL.
			*(yy_c_buf_p) = '\0';

		else
			{ // need more input
			yy_size_t offset = (yy_c_buf_p) - (yytext_ptr);
			++(yy_c_buf_p);

			switch ( yy_get_next_buffer(  ) )
				{
				case EOB_ACT_LAST_MATCH:
					// This happens because yy_g_n_b()
                    // sees that we've accumulated a
                    //token and flags that we need to
                    // try matching the token before
                    // proceeding.  But for input(),
                    // there's no matching to consider.
                    // So convert the EOB_ACT_LAST_MATCH
                    // to EOB_ACT_END_OF_FILE.

					// Reset buffer status.
					ttrestart(ttin );

					//FALLTHROUGH

				case EOB_ACT_END_OF_FILE:
					{
//					if ( ttwrap( ) )
						return 0;

					if ( ! (yy_did_buffer_switch_on_eof) )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput();
#else
					return input();
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					(yy_c_buf_p) = (yytext_ptr) + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) (yy_c_buf_p);	// cast for 8-bit char's
	*(yy_c_buf_p) = '\0';	// preserve tttext
	(yy_hold_char) = *++(yy_c_buf_p);

	return c;
}
#endif	// ifndef YY_NO_INPUT
*/

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * 
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void ttrestart  (FILE * input_file )
{
    
	if ( ! YY_CURRENT_BUFFER ){
        ttensure_buffer_stack ();
		YY_CURRENT_BUFFER_LVALUE =
            tt_create_buffer(ttin,YY_BUF_SIZE );
	}

	tt_init_buffer(YY_CURRENT_BUFFER,input_file );
	tt_load_buffer_state( );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * 
 */
    void tt_switch_to_buffer  (YY_BUFFER_STATE  new_buffer )
{
    
	/* TODO. We should be able to replace this entire function body
	 * with
	 *		ttpop_buffer_state();
	 *		ttpush_buffer_state(new_buffer);
     */
	ttensure_buffer_stack ();
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	tt_load_buffer_state( );

	/* We don't actually know whether we did this switch during
	 * EOF (ttwrap()) processing, but the only time this flag
	 * is looked at is after ttwrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	(yy_did_buffer_switch_on_eof) = 1;
}

static void tt_load_buffer_state  (void)
{
    	(yy_n_chars) = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	(yytext_ptr) = (yy_c_buf_p) = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	ttin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	(yy_hold_char) = *(yy_c_buf_p);
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * 
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE tt_create_buffer  (FILE * file, int  size )
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) ttalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in tt_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) ttalloc(b->yy_buf_size + 2  );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in tt_create_buffer()" );

	b->yy_is_our_buffer = 1;

	tt_init_buffer(b,file );

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with tt_create_buffer()
 * 
 */
    void tt_delete_buffer (YY_BUFFER_STATE  b )
{
    
	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		ttfree((void *) b->yy_ch_buf  );

	ttfree((void *) b  );
}

#ifndef __cplusplus
extern int isatty (int );
#endif /* __cplusplus */
    
/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a ttrestart() or at EOF.
 */
    static void tt_init_buffer  (YY_BUFFER_STATE  b, FILE * file )

{
	int oerrno = errno;
    
	tt_flush_buffer(b );

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then tt_init_buffer was _probably_
     * called from ttrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        //b->yy_is_interactive = file ? (isatty( fileno(file) ) > 0) : 0;
		b->yy_is_interactive = 0;

	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * 
 */
    void tt_flush_buffer (YY_BUFFER_STATE  b )
{
    	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		tt_load_buffer_state( );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  
 */
void ttpush_buffer_state (YY_BUFFER_STATE new_buffer )
{
    	if (new_buffer == NULL)
		return;

	ttensure_buffer_stack();

	/* This block is copied from tt_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*(yy_c_buf_p) = (yy_hold_char);
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = (yy_c_buf_p);
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = (yy_n_chars);
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		(yy_buffer_stack_top)++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from tt_switch_to_buffer. */
	tt_load_buffer_state( );
	(yy_did_buffer_switch_on_eof) = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  
 */
void ttpop_buffer_state (void)
{
    	if (!YY_CURRENT_BUFFER)
		return;

	tt_delete_buffer(YY_CURRENT_BUFFER );
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if ((yy_buffer_stack_top) > 0)
		--(yy_buffer_stack_top);

	if (YY_CURRENT_BUFFER) {
		tt_load_buffer_state( );
		(yy_did_buffer_switch_on_eof) = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void ttensure_buffer_stack (void)
{
	yy_size_t num_to_alloc;
    
	if (!(yy_buffer_stack)) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
		num_to_alloc = 1;
		(yy_buffer_stack) = (struct yy_buffer_state**)ttalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in ttensure_buffer_stack()" );
								  
		memset((yy_buffer_stack), 0, num_to_alloc * sizeof(struct yy_buffer_state*));
				
		(yy_buffer_stack_max) = num_to_alloc;
		(yy_buffer_stack_top) = 0;
		return;
	}

	if ((yy_buffer_stack_top) >= ((yy_buffer_stack_max)) - 1){

		/* Increase the buffer to prepare for a possible push. */
		int grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = (yy_buffer_stack_max) + grow_size;
		(yy_buffer_stack) = (struct yy_buffer_state**)ttrealloc
								((yy_buffer_stack),
								num_to_alloc * sizeof(struct yy_buffer_state*)
								);
		if ( ! (yy_buffer_stack) )
			YY_FATAL_ERROR( "out of dynamic memory in ttensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset((yy_buffer_stack) + (yy_buffer_stack_max), 0, grow_size * sizeof(struct yy_buffer_state*));
		(yy_buffer_stack_max) = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * 
 * @return the newly allocated buffer state object. 
 */
YY_BUFFER_STATE tt_scan_buffer  (char * base, yy_size_t  size )
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return 0;

	b = (YY_BUFFER_STATE) ttalloc(sizeof( struct yy_buffer_state )  );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in tt_scan_buffer()" );

	b->yy_buf_size = size - 2;	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = 0;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	tt_switch_to_buffer(b  );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to ttlex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * 
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       tt_scan_bytes() instead.
 */
YY_BUFFER_STATE tt_scan_string (yyconst char * yystr )
{
    
	return tt_scan_bytes(yystr,strlen(yystr) );
}

/** Setup the input buffer state to scan the given bytes. The next call to ttlex() will
 * scan from a @e copy of @a bytes.
 * @param bytes the byte buffer to scan
 * @param len the number of bytes in the buffer pointed to by @a bytes.
 * 
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE tt_scan_bytes  (yyconst char * yybytes, yy_size_t  _yybytes_len )
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n, i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = _yybytes_len + 2;
	buf = (char *) ttalloc(n  );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in tt_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = tt_scan_buffer(buf,n );
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in tt_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yy_fatal_error (yyconst char* msg )
{
    	(void) fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up tttext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		tttext[ttleng] = (yy_hold_char); \
		(yy_c_buf_p) = tttext + yyless_macro_arg; \
		(yy_hold_char) = *(yy_c_buf_p); \
		*(yy_c_buf_p) = '\0'; \
		ttleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the current line number.
 * 
 */
int ttget_lineno  (void)
{
        
    return ttlineno;
}

/** Get the input stream.
 * 
 */
FILE *ttget_in  (void)
{
        return ttin;
}

/** Get the output stream.
 * 
 */
FILE *ttget_out  (void)
{
        return ttout;
}

/** Get the length of the current token.
 * 
 */
yy_size_t ttget_leng  (void)
{
        return ttleng;
}

/** Get the current token.
 * 
 */

char *ttget_text  (void)
{
        return tttext;
}

/** Set the current line number.
 * @param line_number
 * 
 */
void ttset_lineno (int  line_number )
{
    
    ttlineno = line_number;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param in_str A readable stream.
 * 
 * @see tt_switch_to_buffer
 */
void ttset_in (FILE *  in_str )
{
        ttin = in_str ;
}

void ttset_out (FILE *  out_str )
{
        ttout = out_str ;
}

int ttget_debug  (void)
{
        return tt_flex_debug;
}

void ttset_debug (int  bdebug )
{
        tt_flex_debug = bdebug ;
}

static int yy_init_globals (void)
{
        /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from ttlex_destroy(), so don't allocate here.
     */

    (yy_buffer_stack) = 0;
    (yy_buffer_stack_top) = 0;
    (yy_buffer_stack_max) = 0;
    (yy_c_buf_p) = (char *) 0;
    (yy_init) = 0;
    (yy_start) = 0;

/* Defined in main.c */
#ifdef YY_STDINIT
    ttin = stdin;
    ttout = stdout;
#else
    ttin = (FILE *) 0;
    ttout = (FILE *) 0;
#endif

    /* For future reference: Set errno on error, since we are called by
     * ttlex_init()
     */
    return 0;
}

/* ttlex_destroy is for both reentrant and non-reentrant scanners. */
int ttlex_destroy  (void)
{
    
    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		tt_delete_buffer(YY_CURRENT_BUFFER  );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		ttpop_buffer_state();
	}

	/* Destroy the stack itself. */
	ttfree((yy_buffer_stack) );
	(yy_buffer_stack) = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * ttlex() is called, initialization will occur. */
    yy_init_globals( );

    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, yyconst char * s2, int n )
{
	register int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (yyconst char * s )
{
	register int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

void *ttalloc (yy_size_t  size )
{
	return (void *) malloc( size );
}

void *ttrealloc  (void * ptr, yy_size_t  size )
{
	/* The cast to (char *) in the following accommodates both
	 * implementations that use char* generic pointers, and those
	 * that use void* generic pointers.  It works with the latter
	 * because both ANSI C and C++ allow castless assignment from
	 * any pointer type to void*, and deal with argument conversions
	 * as though doing an assignment.
	 */
	return (void *) realloc( (char *) ptr, size );
}

void ttfree (void * ptr )
{
	free( (char *) ptr );	/* see ttrealloc() for (char *) cast */
}

#define YYTABLES_NAME "yytables"
