/*
Program WinCaml: Graphical User Interface
for interactive use of Caml-Light and Ocaml.
Copyright (C) 2005-2015 Jean Mouric 35700 Rennes France
email: jean.mouric@orange.fr

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>. 
*/

// File COutput.h

#include "platform.h"

class CChildFrame;
class CProcess;

class COutput: public CRichEdit
{
	CChildFrame* cChildFrame;
	bool waitForOutput;
	int nlCount;

	void onKeyDown();
	void onKeyUp();
	void showHide();
	void onLeftButtonUp(bool ctrlDown);
	void onChar(int vKeyCode);
	static void removeTabs(string& str);
public:
	COutput(CChildFrame* cfr);
	~COutput(){}
	void reset();
	void handleCommand(CProcess* process);
	void listen(CProcess* process);
	void setMode(int mode);
	void clear();
	void colorize();
	wstring status();
    void setColors();
};
