#!/bin/sh

#wxWidgets, Linux 64 bit, gtk2

#adapter les variables WXVERSION, WXVER et WXPATH

#version de wxWidgets:
WXVERSION=3.0.0
#WXVER=2.9 si WXVERSION=2.9.5, WXVER=3.0 si WXVERSION=3.0.x
WXVER=3.0

#chemin de la distribution wxWidgets
WXPATH=$HOME/wxWidgets-$WXVERSION

DEFINES="-D__WXGTK__ -DWXUSINGDLL -D_FILE_OFFSET_BITS=64 -DWX_PRECOMP"
INCLUDES="-I. -I$WXPATH/lib/wx/include/gtk2-unicode-$WXVER -I$WXPATH/include -I/usr/include/gtk-2.0 -I/usr/lib/x86_64-linux-gnu/gtk-2.0/include -I/usr/include/atk-1.0 -I/usr/include/cairo -I/usr/include/gdk-pixbuf-2.0 -I/usr/include/pango-1.0 -I/usr/include/gio-unix-2.0/ -I/usr/include/glib-2.0 -I/usr/lib/x86_64-linux-gnu/glib-2.0/include -I/usr/include/pixman-1 -I/usr/include/freetype2 -I/usr/include/libpng12 -I/usr/include/gtk-unix-print-2.0"

g++ -c $DEFINES -Wall -Wundef -Wunused-parameter -Wno-ctor-dtor-privacy -Woverloaded-virtual -O2 -pthread -fno-strict-aliasing -fvisibility=hidden -fvisibility-inlines-hidden $INCLUDES ../../sources/wx/*.cpp ../../sources/All/*.cpp

LIBS="-lwx_gtk2u_stc-$WXVER -lwx_gtk2u_core-$WXVER -lwx_baseu-$WXVER -lwxscintilla-$WXVER -lgtk-x11-2.0 -lgdk-x11-2.0 -latk-1.0 -lgio-2.0 -lpangoft2-1.0 -lpangocairo-1.0 -lgdk_pixbuf-2.0 -lcairo -lpango-1.0 -lfreetype -lfontconfig -lgobject-2.0 -lgthread-2.0 -lrt -lglib-2.0 -lX11 -lSM -lpng -lz  -lwxregexu-$WXVER -ldl -lm"

g++ -o WinCaml *.o -Wl,-rpath,$WXPATH/lib -Wl,--version-script,$WXPATH/version-script -pthread -L$WXPATH/lib $LIBS

rm *.o
test -d WinCaml5 || mkdir WinCaml5
test -d WinCaml5/ocaml || mkdir WinCaml5/ocaml
mv WinCaml WinCaml5
cp -Rf ../../caml/ocaml/linux WinCaml5/ocaml
cp -Rf ../../caml/ocaml/htmlman WinCaml5/ocaml
cp -Rf ../../caml/caml-light  WinCaml5
rm -f WinCaml5/caml-light/bin/caml*
rm -f WinCaml5/caml-light/bin/mac*
chmod +x WinCaml5/caml-light/bin/lin*
cp -Rf ../../caml/exemples WinCaml5

cp a/WinCamlIcon.png WinCaml5
test -d "$HOME"/WinCaml5 && rm -rf "$HOME"/WinCaml5
mv WinCaml5 "$HOME"
cp a/WinCaml.txt "$HOME"/WinCaml.desktop
echo Exec="$HOME"/WinCaml5/WinCaml %F >> "$HOME"/WinCaml.desktop
echo Icon="$HOME"/WinCaml5/WinCamlIcon.png >> "$HOME"/WinCaml.desktop
echo Path="$HOME"/WinCaml5 >> "$HOME"/WinCaml.desktop

