@echo off

set VCID=%1
set ARCH=%2

if "%VCID%" == "6" (
	if "%ProgramFiles(x86)%" == "" (
		call "C:\Program Files\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"
	) else (
		call "%ProgramFiles(x86)%\Microsoft Visual Studio\VC98\Bin\VCVARS32.BAT"
	)
	set DEFINES=/D "_WINDOWS_PLATFORM_" /D "WIN32" /D "_WINDOWS" /D "_MSVC98_" /D "_WIN2000_" /D "_UNICODE" /D "UNICODE"
	set CONTEXT=2000
	set LINKOPTIONS=

) else (
	if "%ARCH%" == "x64" (
		set CONTEXT=64
		if "%VCID%" == "9" (
			call "C:\Program Files (x86)\Microsoft Visual Studio %VCID%.0\VC\bin\vcvarsx86_amd64.bat"
		) else (
			call "C:\Program Files (x86)\Microsoft Visual Studio %VCID%.0\VC\vcvarsall.bat" x86_amd64
		)
	) else (
		set CONTEXT=32
		if "%ProgramFiles(x86)%" == "" (
			call "C:\Program Files\Microsoft Visual Studio %VCID%.0\VC\bin\vcvars32.bat"
		) else (
			call "%ProgramFiles(x86)%\Microsoft Visual Studio %VCID%.0\VC\bin\vcvars32.bat"
		)
	)
	set DEFINES=/D_WINDOWS_PLATFORM_ /D "WIN32" /D "_WINDOWS" /D "_MSVC2010_" /D "_UNICODE" /D "UNICODE"
	set LINKOPTIONS=/DYNAMICBASE /NXCOMPAT
)

set LIBS=comctl32.lib kernel32.lib user32.lib gdi32.lib winspool.lib comdlg32.lib advapi32.lib shell32.lib ole32.lib oleaut32.lib uuid.lib odbc32.lib odbccp32.lib shlwapi.lib

cl.exe /O2 %DEFINES% /EHsc /MT /Fo".\\" /W3 /c /TP ..\sources\All\*.cpp ..\sources\Win\*.cpp
rc.exe /D_WINDOWS_PLATFORM_ /fo ".\WinCaml.res" "..\sources\Win\resources\WinCaml%CONTEXT%.rc"
link.exe /OUT:".\WinCaml.exe" /RELEASE /SUBSYSTEM:WINDOWS %LINKOPTIONS% /MACHINE:%ARCH% %LIBS% ".\WinCaml.res" ".\*.obj"
del .\*.obj
del .\*.res

xcopy /q /s /y /i ..\caml\ocaml\windows WinCaml5\ocaml\windows\
move /y WinCaml.exe WinCaml5
copy ..\sources\Win\WinCamlInit.bat WinCaml5
xcopy /q /s /y /i ..\caml\ocaml\htmlman WinCaml5\ocaml\htmlman\
xcopy /q /s /y /i ..\caml\"caml-light"  WinCaml5\"caml-light"\
del WinCaml5\"caml-light"\bin\lin*
del WinCaml5\caml-light"\bin\mac*
xcopy /q /s /y /i ..\caml\exemples WinCaml5\exemples\

